
<div class="card mb-3 mb-lg-5">
    <div class="card-header card-header-content-sm-between">
        <h4 class="card-header-title mb-2 mb-sm-0"><?php echo app('translator')->get('Order Sales'); ?></h4>
        <div class="d-grid d-sm-flex gap-2">
            <button id="js-daterangepicker-predefined" class="btn btn-white btn-sm dropdown-toggle">
                <i class="bi-calendar-week"></i>
                <span class="js-daterangepicker-predefined-preview ms-1"></span>
            </button>
        </div>
    </div>
    <div class="card-body">
        <div class="row col-lg-divider" id="salesRevenueChart" style="max-height: 350px">
            <div class="col-lg-9 mb-5 mb-lg-0">
                <div class="chartjs-custom mb-4" style="max-height: 350px">
                    <canvas id="ecommerce-product-sales-revenue" style="max-height: 350px"></canvas>
                </div>
            </div>

            <div class="col-lg-3">
                <div class="row">
                    <div class="col-sm-6 col-lg-12">
                        <div class="d-flex justify-content-center flex-column" style="min-height: 9rem;">
                            <h6 class="card-subtitle"><?php echo app('translator')->get('Revenue'); ?></h6>
                            <span class="d-block display-4 text-dark mb-1 me-3 revenueData"><?php echo e(currencyPosition(0)); ?></span>
                            <span class="d-block text-success" id="revenuePercent"></span>
                        </div>

                        <hr class="d-none d-lg-block my-0">
                    </div>

                    <div class="col-sm-6 col-lg-12">
                        <div class="d-flex justify-content-center flex-column" style="min-height: 9rem;">
                            <h6 class="card-subtitle"><?php echo app('translator')->get('Sales'); ?></h6>
                            <span class="d-block display-4 text-dark mb-1 me-3 orderData"><?php echo e(0); ?></span>
                            <span class="d-block text-danger" id="orderPercent"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/daterangepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).on('ready', function () {
            HSCore.components.HSTomSelect.init('.js-select');
            $('.js-daterangepicker').daterangepicker();

            $('.js-daterangepicker-times').daterangepicker({
                timePicker: true,
                startDate: moment().startOf('hour'),
                endDate: moment().startOf('hour').add(32, 'hour'),
                locale: {
                    format: 'M/DD hh:mm A'
                }
            });

            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $('#js-daterangepicker-predefined .js-daterangepicker-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));
                $('#js-daterangepicker-predefined-country .js-daterangepicker-predefined-preview-country').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));
            }

            $('#js-daterangepicker-predefined').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            $('#js-daterangepicker-predefined-country').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

            var ctx = document.getElementById('ecommerce-product-sales-revenue').getContext('2d');
            var salesChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: [],
                    datasets: []
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 100,
                                color: '#97a4af',
                                font: {
                                    size: 12,
                                    family: 'Open Sans, sans-serif'
                                },
                                padding: 10
                            }
                        },
                        x: {
                            ticks: {
                                color: '#97a4af',
                                font: {
                                    size: 12,
                                    family: 'Open Sans, sans-serif'
                                },
                                padding: 5
                            },
                            categoryPercentage: 0.5,
                            maxBarThickness: 10
                        }
                    },
                    plugins: {
                        tooltip: {
                            mode: 'index',
                            intersect: false
                        }
                    },
                    hover: {
                        mode: 'nearest',
                        intersect: true
                    }
                }
            });

            function fetchDataAndUpdateChart() {
                let selectedStore = $('.js-select').val();
                let dateRange = $('#js-daterangepicker-predefined').data('daterangepicker');
                let startDate = dateRange.startDate.format('YYYY-MM-DD');
                let endDate = dateRange.endDate.format('YYYY-MM-DD');

                $.ajax({
                    url: '<?php echo e(route("admin.get.productSalesRevenueHistory")); ?>',
                    method: 'GET',
                    data: {
                        store: selectedStore,
                        start_date: startDate,
                        end_date: endDate
                    },
                    success: function (data) {
                        salesChart.data.labels = data.labels;
                        salesChart.data.datasets = data.datasets;
                        salesChart.update();

                        let revenuePercentage = data.revenuePercentageChange;
                        let revenuePercentageValue = data.revenuePercentageValue;
                        let orderPercentage = data.orderPercentageChange;
                        let orderPercentageValue = data.orderPercentageValue;

                        let totalEarned = data.datasets[0].data.reduce((a, b) => a + b, 0);
                        let totalOrders = data.datasets[1].data.reduce((a, b) => a + b, 0);

                        document.querySelector('.revenueData').innerHTML = currencyPosition(totalEarned);
                        document.querySelector('.orderData').innerHTML = totalOrders;

                        let revenueIconClass = revenuePercentage.includes('-') ? 'bi-graph-down' : 'bi-graph-up';
                        let revenueColorClass = revenuePercentage.includes('-') ? 'text-danger' : 'text-success';
                        let revenuePercentElement = document.getElementById('revenuePercent');
                        revenuePercentElement.className = revenueColorClass;
                        revenuePercentElement.innerHTML = `<i class="${revenueIconClass} me-1"></i> ${currencyPosition(Math.abs(revenuePercentageValue))} (${Math.abs(parseFloat(revenuePercentage)).toFixed(1)}%)`;

                        let orderIconClass = orderPercentage.includes('-') ? 'bi-graph-down' : 'bi-graph-up';
                        let orderColorClass = orderPercentage.includes('-') ? 'text-danger' : 'text-success';
                        let orderPercentElement = document.getElementById('orderPercent');
                        orderPercentElement.className = orderColorClass;
                        orderPercentElement.innerHTML = `<i class="${orderIconClass} me-1"></i> ${Math.abs(orderPercentageValue)} (${Math.abs(parseFloat(orderPercentage)).toFixed(1)}%)`;
                    },
                    error: function (error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }

            // Event listeners
            $('.js-select').on('change', fetchDataAndUpdateChart);
            $('#js-daterangepicker-predefined').on('apply.daterangepicker', fetchDataAndUpdateChart);

            // Initial data fetch
            fetchDataAndUpdateChart();
        });

        function currencyPosition(amount) {
            var basic = <?php echo json_encode(basicControl(), 15, 512) ?>;

            amount = parseFloat(amount).toFixed(2);
            amount = parseFloat(amount).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });

            if (basic.is_currency_position === 'left' && basic.has_space_between_currency_and_amount) {
                return basic.currency_symbol + ' ' + amount;
            } else if (basic.is_currency_position === 'left' && !basic.has_space_between_currency_and_amount) {
                return basic.currency_symbol + amount;
            } else if (basic.is_currency_position === 'right' && basic.has_space_between_currency_and_amount) {
                return amount + ' ' + basic.currency_symbol;
            } else {
                return amount + ' ' + basic.currency_symbol;
            }
        }


    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/admin/partials/dashboard/orderSalesRevenue.blade.php ENDPATH**/ ?>