<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <meta content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>" name="description">
        <meta content="<?php echo e(is_array(@$pageSeo['meta_keywords']) ? implode(', ', @$pageSeo['meta_keywords']) : @$pageSeo['meta_keywords']); ?>"
              name="keywords">
        <meta name="theme-color" content="<?php echo e(basicControl()->primary_color); ?>">
        <meta name="author" content="<?php echo e(basicControl()->site_title); ?>">
        <meta name="robots" content="<?php echo e(isset($pageSeo['meta_robots']) ? $pageSeo['meta_robots'] : ''); ?>">

        <meta property="og:type" content="website">
        <meta property="og:site_name" content="<?php echo e(isset(basicControl()->site_title) ? basicControl()->site_title : ''); ?>">
        <meta property="og:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
        <meta property="og:description" content="<?php echo e(isset($pageSeo['og_description']) ? $pageSeo['og_description'] : ''); ?>">
        <meta property="og:image" content="<?php echo e(@$pageSeo['meta_image']); ?>">

        <meta name="twitter:card" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
        <meta name="twitter:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
        <meta name="twitter:description" content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>">
        <meta name="twitter:image" content="<?php echo e(@$pageSeo['meta_image']); ?>">

        <title> <?php echo e(basicControl()->site_title); ?> <?php if(isset($pageSeo['page_title'])): ?>
                | <?php echo e(str_replace(basicControl()->site_title, ' ',$pageSeo['page_title'])); ?>

            <?php else: ?>
                 | <?php echo $__env->yieldContent('title'); ?>
            <?php endif; ?></title>

        <!-- Favicons -->
        <link href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>" rel="icon">

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/bootstrap.min.css')); ?>"/>
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/all.min.css')); ?>"/>
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/fontawesome.min.css')); ?>"/>
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/animate.css')); ?>"/>
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/owl.carousel.min.css')); ?>"/>
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/owl.theme.default.min.css')); ?>"/>
        <link href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>" rel="stylesheet">
        <?php echo $__env->yieldPushContent('css-lib'); ?>
        <?php echo $__env->yieldPushContent('style'); ?>
        <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
        <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/style.css')); ?>"/>
    </head>

    <body>
        <?php echo $__env->make($theme.'partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make($theme.'partials.bottom_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->yieldContent('content'); ?>

        <?php if(basicControl()->cookie_status == 1): ?>
            <?php echo $__env->make(template().'partials.cookie', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make(template().'partials.pwa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script src="<?php echo e(asset($themeTrue . 'js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset($themeTrue . 'js/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset($themeTrue . 'js/owl.carousel.min.js')); ?>"></script>
        <script src="<?php echo e(asset($themeTrue . 'js/qrjs2.min.js')); ?>"></script>
        <script src="<?php echo e(asset($themeTrue . 'js/socialSharing.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
        <script src="<?php echo e(asset($themeTrue . 'js/script.js')); ?>"></script>
        <?php echo $__env->yieldPushContent('js-lib'); ?>
        <?php echo $__env->yieldPushContent('script'); ?>

        <?php if(session()->has('success')): ?>
            <script>
                Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");
            </script>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <script>
                Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");
            </script>
        <?php endif; ?>
        <?php if(session()->has('warning')): ?>
            <script>
                Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");
            </script>
        <?php endif; ?>
    </body>
</html>


<?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/themes/light/layouts/app.blade.php ENDPATH**/ ?>