
<?php $__env->startSection('page_title', __('Language Setting')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Settings'); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Language Settings'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Language Settings'); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-9">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h2 class="card-title h4 mt-3"><?php echo app('translator')->get("Languages"); ?></h2>
                            <a href="<?php echo e(route('admin.language.create')); ?>"
                               class="btn btn-primary btn-sm"><?php echo app('translator')->get("Add Language"); ?>
                            </a>
                        </div>
                        <div class="table-responsive position-relative">
                            <table
                                class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                                id="supported_currency_table">
                                <thead class="thead-light">
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Short Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>

                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo app('translator')->get($language->name); ?></td>
                                        <td><?php echo app('translator')->get($language->short_name); ?></td>
                                        <td>
                                            <?php if($language->default_status): ?>
                                                <span class="badge bg-soft-primary text-primary">
                                                    <span class="legend-indicator bg-primary"></span><?php echo app('translator')->get('Default'); ?>
                                                </span>
                                            <?php endif; ?>

                                            <span
                                                class="badge bg-soft-<?php echo e($language->getStatusClass()); ?> text-<?php echo e($language->getStatusClass()); ?>">
                                                <span
                                                    class="legend-indicator bg-<?php echo e($language->getStatusClass()); ?>"></span><?php echo e($language->status ? __('Active') : 'Inactive'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a class="btn btn-white btn-sm"
                                                   href="<?php echo e(route('admin.language.edit', $language->id)); ?>">
                                                    <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get('Edit'); ?>
                                                </a>
                                                <div class="btn-group">
                                                    <button type="button"
                                                            class="btn btn-white btn-icon btn-sm dropdown-toggle dropdown-toggle-empty"
                                                            id="productsEditDropdown1" data-bs-toggle="dropdown"
                                                            aria-expanded="false"></button>

                                                    <div class="dropdown-menu dropdown-menu-end mt-1"
                                                         aria-labelledby="productsEditDropdown1">
                                                        <a href="<?php echo e(route('admin.language.keywords', $language->short_name)); ?>"
                                                           class="dropdown-item">
                                                            <i class="fas fa-code dropdown-item-icon"></i> <?php echo app('translator')->get('Keywords'); ?>
                                                        </a>
                                                        <?php if(!$language->default_status): ?>
                                                            <a href=""
                                                               class="dropdown-item status-change"
                                                               data-bs-toggle="modal"
                                                               data-bs-target="#statusChangeModal"
                                                               data-route="<?php echo e(route('admin.change.language.status', $language->id)); ?>"
                                                               data-status="<?php echo app('translator')->get('Do you want to'); ?> <?php echo e($language->status == 0 ? trans('activate') : trans('deactivate')); ?> <?php echo app('translator')->get('this'); ?> `<?php echo app('translator')->get($language->name); ?>` <?php echo app('translator')->get('language?'); ?>">
                                                                <i class="fa-light fa-<?php echo e($language->status == 0 ? 'check' : 'ban'); ?> dropdown-item-icon"></i>
                                                                <?php echo e($language->status == 0 ? trans('Activate') : trans('Deactivate')); ?>

                                                            </a>
                                                            <?php if($language->short_name !== 'en'): ?>
                                                                <a href="<?php echo e(route('admin.language.delete', $language->id)); ?>"
                                                                   type="button"
                                                                   data-bs-toggle="modal"
                                                                   data-bs-target="#deleteModal"
                                                                   data-route="<?php echo e(route('admin.language.delete', $language->id)); ?>"
                                                                   data-text="`<?php echo app('translator')->get($language->name); ?>` <?php echo app('translator')->get('language'); ?>"
                                                                   class="dropdown-item deleteBtn">
                                                                    <i class="bi-trash dropdown-item-icon"></i> <?php echo app('translator')->get('Delete'); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <div class="text-center p-4">
                                        <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                                        <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                                        <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                    </div>
                                </tr>
                                <?php endif; ?>
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Content -->

    <!-- Status Change Modal -->
    <div class="modal fade" id="statusChangeModal" tabindex="-1" role="dialog" aria-labelledby="statusChangeModalLabel" data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="accountAddCardModalLabel"><i class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" class="setRoute">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('put'); ?>
                    <div class="modal-body">
                        <span class="status-change-text"></span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Confirm"); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Status Change Modal -->

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="accountAddCardModalLabel"><i class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" class="setRoute">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>
                    <div class="modal-body">
                        <?php echo app('translator')->get('Do you want to delete this'); ?> <span class="delete-text"></span> ?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get("Close"); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Confirm"); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict'
        $(document).on('click', '.deleteBtn', function () {
            let url = $(this).data('route');
            let deleteText = $(this).data('text');
            $('.delete-text').text(deleteText);
            $('.setRoute').attr('action', url);
        })

        $(document).on('click', '.status-change', function () {
            let url = $(this).data('route');
            let statusText = $(this).data('status');
            $('.status-change-text').text(statusText);
            $('.setRoute').attr('action', url);
        })

    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\FoodyFriend-v3\DEMO\resources\views/admin/language/list.blade.php ENDPATH**/ ?>