@extends(template().'layouts.user')
@section('page_title',__('Tickets Log'))

@section('content')
    <div class="container-fluid">
        <div class="main row">
            <div class="col-12">
                <div class="dashboard-heading">
                    <h2 class="mb-0">@lang('Support Tickets')</h2>
                    <div>
                        <a href="{{ route('user.ticket.create') }}" class="btn-custom customButton">
                            <i class="fal fa-plus"></i>@lang('Create')
                        </a>
                        <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
                    </div>
                </div>
                <div class="table-parent table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th scope="col">@lang('Subject')</th>
                            <th scope="col">@lang('Status')</th>
                            <th scope="col">@lang('Created At')</th>
                            <th scope="col">@lang('Last Reply')</th>
                            <th scope="col">@lang('Action')</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($tickets as $key => $ticket)
                            <tr>
                                <td data-label="@lang('Subject')">
                                    [{{ trans('Ticket# ').__($ticket->ticket) }}
                                    ] {{ __($ticket->subject) }}
                                </td>
                                <td data-label="@lang('Status')">
                                    @if($ticket->status == 0)
                                        <span class="badge bg-warning text-warning">@lang('Open')</span>
                                    @elseif($ticket->status == 1)
                                        <span class="badge bg-success text-success">@lang('Answered')</span>
                                    @elseif($ticket->status == 2)
                                        <span class="badge bg-info text-info">@lang('Replied')</span>
                                    @elseif($ticket->status == 3)
                                        <span class="badge bg-danger text-danger">@lang('Closed')</span>
                                    @endif
                                </td>
                                <td data-label="@lang('Created At')">
                                    {{ dateTime($ticket->created_at) }}
                                </td>
                                <td data-label="@lang('Last Reply')">
                                    {{ __(diffForHumans($ticket->last_reply)) }}
                                </td>
                                <td data-label="@lang('Action')">
                                    <a href="{{ route('user.ticket.view', $ticket->ticket) }}"
                                       class="btn-modify">
                                        @lang('View')
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr class="text-center">
                                <th class="text-center" colspan="100%">
                                    <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                    <p class="mt-3">@lang('No data available')</p>
                                </th>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <nav aria-label="Page navigation example">
                    <ul class="pagination justify-content-center">
                        {{ $tickets->appends($_GET)->links(template().'partials.pagination') }}
                    </ul>
                </nav>
            </div>
        </div>
    </div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Subject')" name="subject" value="{{ request()->subject ?? '' }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Ticket No')" name="ticket" value="{{ request()->ticket ?? '' }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Date')" name="created_at" id="created_at"
                                   value="{{ request()->created_at ?? '' }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
