@extends(template().'layouts.user')
@section('page_title',__('Shipping Charge'))

@section('content')
	<div id="category" v-cloak>
		<div class="container-fluid">
			<div class="main row">
				<div class="col-12">
					<div class="dashboard-heading">
						<h2 class="mb-0">@lang('Shipping Charge')</h2>
                        <div>
                            <a href="javascript:void(0)" data-bs-target="#addShipping"
                               @click="makeEmpty"
                               data-bs-toggle="modal" class="btn-custom customButton"><i class="fal fa-plus"></i>@lang('Create') </a>
                            <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
                        </div>
					</div>
					<div class="table-parent table-responsive">
						<table
							class="table table-striped">
							<thead class="thead-light">
							<tr>
								<th>@lang('SL.')</th>
								<th>@lang('Store')</th>
								<th>@lang('Address')</th>
								<th>@lang('Cost')</th>
								<th>@lang('Status')</th>
								<th>@lang('Created At')</th>
								<th>@lang('Action')</th>
							</tr>
							</thead>
							<tbody>
							@forelse($shipping as $key => $item)
								<tr>
									<td data-label="@lang('SL.')">{{++$key}}</td>
									<td data-label="@lang('Store')">
										<a href="{{route('user.store.shipping.update')}}"
										   class="text-decoration-none">
											<p class="text-dark mb-0 font-16 font-weight-medium">{{Str::limit(optional($item->store)->name ?? __('N/A'),20)}}</p>
										</a>
									</td>
									<td data-label="@lang('Address')">{{ $item->address }}</td>
									<td data-label="@lang('Cost')">{{ currencyPosition(getAmount($item->charge+0)) }}</td>
									<td data-label="@lang('Status')">
										@if($item->status == 1)
											<span class="badge bg-success">@lang('Active')</span>
										@else
											<span class="badge bg-danger">@lang('Inactive')</span>
										@endif
									</td>
                                    <td data-label="@lang('Created At')">{{dateTime($item->created_at)}}</td>
									<td data-label="Action">
										<div class="sidebar-dropdown-items">
											<button
												type="button"
												class="dropdown-toggle customButton"
												data-bs-toggle="dropdown"
												aria-expanded="false">
												<i class="fal fa-cog"></i>
											</button>
											<ul class="dropdown-menu dropdown-menu-end">
												<li>
													<a href="javascript:void(0)" @click="edit({{$item}})"
													   data-bs-target="#editCategory"
													   data-bs-toggle="modal"
													   class="dropdown-item"> <i
															class="fal fa-edit"></i> @lang('Edit') </a>
												</li>
												<li>
													<button class="dropdown-item deleteShipping" type="button"
															data-bs-target="#categoryDelete"
															data-bs-toggle="modal"
															data-route="{{route('user.store.shipping.delete',$item->id)}}">
														<i class="fal fa-trash text-danger"></i> @lang('Delete')
													</button>
												</li>
											</ul>
										</div>
									</td>
								</tr>
							@empty
                                <tr class="text-center">
                                    <th class="text-center" colspan="100%">
                                        <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                        <p class="mt-3">@lang('No data available')</p>
                                    </th>
                                </tr>
							@endforelse
							</tbody>
						</table>
					</div>
                    <nav aria-label="Page navigation example">
                        <ul class="pagination justify-content-center">
                            {{ $shipping->appends($_GET)->links(template().'partials.pagination') }}
                        </ul>
                    </nav>
				</div>
			</div>
		</div>
		@include(template().'user.store.shipping.modal')
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="col-lg-12">
                            <div class="input-box form-group">
                                <input placeholder="@lang('Store Name')" name="store_name" value="{{@request()->store_name}}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="input-box form-group">
                                <input placeholder="@lang('Address')" name="address" value="{{@request()->address}}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="input-box form-group">
                                <select name="status" class="form-select" aria-label="Default select example">
                                    <option value="">@lang('All Status')</option>
                                    <option
                                        value="1" {{ @request()->status == '0' ? 'selected' : '' }}>@lang('Active')</option>
                                    <option
                                        value="0" {{ @request()->status == '1' ? 'selected' : '' }}>@lang('Inactive')</option>
                                </select>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Date')" name="created_at" id="created_at"
                                   value="{{ request()->created_at ?? '' }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
	<script>
		'use strict'
		var newApp = new Vue({
			el: "#category",
			data: {
				item: {
					address: "", status: "", id: "", store: "", charge: ""
				},
				stores: [],
				addressError: "", storeError: "", chargeError: ""
			},
			mounted() {
				this.item.status = 1;
				this.stores = @json($stores);
			},
			methods: {
				save() {
					this.makeError();
					axios.post("{{ route('user.store.shipping.store') }}", this.item)
						.then(function (response) {
							if (response.data.status == 'success') {
								window.location.href = response.data.url;
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
						});
				},
				edit(obj) {
					this.item.address = obj.address;
					this.item.id = obj.id;
					this.item.status = obj.status;
					this.item.store = obj.store.id;
					this.item.charge = parseFloat(obj.charge).toFixed(2);
				},
				update() {
					this.makeError();
					axios.post("{{ route('user.store.shipping.update') }}", this.item)
						.then(function (response) {
							if (response.data.status == 'success') {
								window.location.href = response.data.url;
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
						});
				},
				makeError() {
					if (!this.item.address) {
						this.addressError = "Address Field is required"
					}
					if (!this.item.store) {
						this.storeError = "Store Field is required"
					}

					if (!this.item.charge) {
						this.chargeError = "Charge Field is required"
					}
				},
				makeEmpty() {
					this.item.address = "";
					this.item.store = "";
					this.item.charge = "";
					this.item.status = 1;
					this.addressError = "";
					this.storeError = "";
					this.chargeError = "";
				}
			},
		})
		$(document).on('click', '.deleteShipping', function () {
			var route = $(this).data('route');
            console.log(route)
			$('.deleteShippingForm').attr('action', route);
		})

		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
		});

	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
