@extends(template().'layouts.user')
@section('page_title',__('Add ons'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-lg-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Create Add ons')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.menu.optional.create') }}" method="post" enctype="multipart/form-data">
							@csrf
							<div class="row align-items-center">
								<div class="input-box col-md-6">
									<div class="form-group">
										<label for="Product Name">@lang('Add ons Name')</label>
										<input type="text" value="{{ old('name') }}"
											   name="name"
											   class="form-control @error('name') is-invalid @enderror"
											   autocomplete="off" required>
										<div class="invalid-feedback">
											@error('name') @lang($message) @enderror
										</div>
									</div>
								</div>

								<div class="input-box col-md-6">
									<div class="form-group">
										<label for="Price">@lang('Price')</label>
										<div class="input-group">
											<input type="number" step="0.001" value="{{ old('price') }}"
												   name="price"
												   class="form-control @error('price') is-invalid @enderror"
												   autocomplete="off" required>
											<button type="button" class="btn-modify">
												<span class="">{{ basicControl()->base_currency }}</span>
											</button>
										</div>
										<div class="invalid-feedback">
											@error('price') @lang($message) @enderror
										</div>
									</div>
								</div>

							</div>
							<div class="row mt-2">
								<div class="col-sm-12 col-md-6 input-box mb-4">
									<label>@lang('Image')</label>
									<div class="form-group position-relative">
										<div class="image-input z0">
											<label for="image-upload" id="image-label"><i
													class="fas fa-upload"></i></label>
											<input type="file" id="image" name="image"
												   placeholder="@lang('Choose image')" class="image-preview" required>
											<img id="image_preview_container" class="preview-image"
												 src="{{ getFile(config('location.default2')) }}"
												 alt="@lang('preview image')">
										</div>
									</div>
									<div class="invalid-feedback">
										@error('image') @lang($message) @enderror
									</div>

									@if(config("filelocation.optionalProduct.size"))
										<span class="text-warning">{{trans('Image size should be')}} {{config("filelocation.optionalProduct.size")}} {{trans('px')}}</span>
									@endif
								</div>
								<div class="input-box col-md-6">
									<label>@lang('Status')</label>
									<div class="selectgroup w-100">
										<label class="selectgroup-item">
											<input type="radio" name="status"
												   value="0"
												   class="selectgroup-input">
											<span class="selectgroup-button">@lang('OFF')</span>
										</label>
										<label class="selectgroup-item">
											<input type="radio" name="status"
												   value="1"
												   class="selectgroup-input" checked>
											<span class="selectgroup-button">@lang('ON')</span>
										</label>
									</div>
								</div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Create New')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection
@push('script')
	<script>
		'use strict';
		$(document).on('change', '.image-preview', function () {
			let reader = new FileReader();
			reader.onload = (e) => {
				$('#image_preview_container').attr('src', e.target.result);
			}
			reader.readAsDataURL(this.files[0]);
		});
	</script>
@endpush

