@extends(template().'layouts.user')
@section('page_title',__('Store List'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Store List')</h2>
					<div>
                        <a href="{{ route('user.store.create') }}" class="btn-custom customButton"><i class="fal fa-plus"></i>@lang('Create') </a>
                        <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
                    </div>
				</div>
				<div class="table-parent table-responsive">
					<table class="table table-striped">
						<thead class="thead-light">
						<tr>
							<th scope="col">@lang('SL.')</th>
							<th scope="col">@lang('Name')</th>
							<th scope="col">@lang('Menu')</th>
							<th scope="col">@lang('Shipping Charge')</th>
							<th scope="col">@lang('Status')</th>
							<th scope="col">@lang('Delivery Note')</th>
							<th scope="col">@lang('Action')</th>
						</tr>
						</thead>
						<tbody>
						@forelse($stores as $key => $item)
							<tr>
								<td data-label="@lang('SL.')">{{++$key}}</td>
								<td data-label="@lang('Name')">{{ $item->name }}</td>
								<td data-label="@lang('Menu')">
									<span class="badge2">{{ $item->productsCount() }}</span>
                                </td>
								<td data-label="@lang('Shipping Charge')">
									@if($item->shipping_charge == 1)
										<span
											class="badge bg-primary">@lang('Enable')</span>
									@else
										<span
											class="badge bg-secondary">@lang('Disable')</span>
									@endif
								</td>
								<td data-label="@lang('Status')">
									@if($item->status == 1)
										<span
											class="badge bg-success">@lang('Active')</span>
									@else
										<span
											class="badge bg-danger">@lang('Inactive')</span>
									@endif
								</td>
								<td data-label="@lang('Delivery Note')">
									<span class="badge {{ (ucfirst($item->delivery_note) != 'Disabled') ? 'bg-info' : 'bg-dark' }}">{{ ucfirst($item->delivery_note) }}</span>
								</td>
								<td data-label="Action">
									<div class="sidebar-dropdown-items">
										<button
											type="button"
											class="dropdown-toggle customButton"
											data-bs-toggle="dropdown"
											aria-expanded="false">
											<i class="fal fa-cog"></i>
										</button>
										<ul class="dropdown-menu dropdown-menu-end">
											<li>
												<a href="{{route('user.store.edit',$item->id)}}" class="dropdown-item"> <i
														class="fa fa-edit"></i> @lang('Edit') </a>
											</li>
											<li>
												<a href="{{route('user.store.telegram.set',$item->id)}}"
												   class="dropdown-item"> <i
														class="fab fa-telegram telegram-color"></i> @lang('Telegram Bot') </a>
											</li>
                                            <li>
                                                <a href="{{route('user.store.whatsapp.set',$item->id)}}"
                                                   class="dropdown-item"> <i
                                                        class="fa fa-phone-square-alt whatsapp-color"></i> @lang('Whatsapp Bot') </a>
                                            </li>
											<li>
												<a href="{{route('user.store.messenger.set',$item->id)}}"
												   class="dropdown-item"> <i
														class="fab fa-facebook-messenger messenger-color"></i> @lang('Messenger Bot') </a>
											</li>

											<li>
												<a href="{{route('user.store.command.set',$item->id)}}"
												   class="dropdown-item"> <i
														class="fa fa-user-md-chat text-indigo"></i> @lang('Bot Command') </a>
											</li>
											<li>
												<a href="{{route('user.store.qr.code',$item->id)}}"
												   class="dropdown-item"> <i
														class="fa fa-qrcode text-info"></i> @lang('QR Code') </a>
											</li>
											<li>
												<button class="dropdown-item deleteStore" type="button"
														data-bs-target="#storeDelete"
														data-bs-toggle="modal"
														data-route="{{route('user.store.delete',$item->id)}}">
													<i class="fa fa-trash text-danger"></i> @lang('Delete')
												</button>
											</li>
										</ul>
									</div>
								</td>
							</tr>
						@empty
                            <tr class="text-center">
                                <th class="text-center" colspan="100%">
                                    <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                    <p class="mt-3">@lang('No data available')</p>
                                </th>
                            </tr>
						@endforelse
						</tbody>
					</table>
				</div>
				<nav aria-label="Page navigation example">
					<ul class="pagination justify-content-center">
						{{ $stores->appends($_GET)->links(template().'partials.pagination') }}
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="modal fade" id="storeDelete" tabindex="-1" aria-labelledby="storeDelete" aria-hidden="true">
		<div class="modal-dialog modal-dialog-top modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">@lang('Delete Confirmation')</h5>
					<button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
						<i class="fal fa-times"></i>
					</button>
				</div>
				<div class="modal-body">
					<div class="row g-4">
						<p>@lang('Are you sure to delete this store?')</p>
					</div>
				</div>
				<div class="modal-footer">
					<form action="" method="post" class="deleteStoreForm">
                        @csrf
						@method('delete')
						<button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
						<button type="submit" class="btn-custom">@lang('Yes')</button>
					</form>
				</div>
			</div>
		</div>
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Store Name')" name="name" value="{{ request()->name ?? '' }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Date')" name="created_at" id="created_at"
                                   value="{{ request()->created_at ?? '' }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group search-currency-dropdown">
                                <select name="status" class="form-select" aria-label="Default select example">
                                    <option value="">@lang('All Status')</option>
                                    <option  value="1" {{ isset(request()->status) && request()->status == 1 ? 'selected' : '' }}>@lang('Active')</option>
                                    <option  value="0" {{ isset(request()->status) && request()->status == 0 ? 'selected' : '' }}>@lang('Inactive')</option>
                                </select>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('script')
	<script>
		'use strict'
		$(document).on('click', '.deleteStore', function () {
			var route = $(this).data('route');
			$('.deleteStoreForm').attr('action', route);
		})

	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
