@extends(template().'layouts.user')
@section('page_title',__('Edit Store'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Edit Store')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.update',$store->id) }}" method="post">
							@csrf
                            @method('PUT')
							<div class="row">
								<div class="col-md-8">
									<div class="row">
										<div class="col-md-12">
											<div class="input-box form-group">
												<label for="Store Name">@lang('Store Name')</label>
												<input type="text"
													   name="name"
													   value="{{ old('name',$store->name) }}"
													   class="form-control"
													   placeholder="@lang('Maxcoach')"
													   autocomplete="off" required>
												<div class="text-danger">
													@error('name') @lang($message) @enderror
												</div>
											</div>
										</div>
									</div>
									<div class="row mt-3">
										<div class="col-md-12">
											<div class="input-box form-group">
												<label
													for="Store Description">@lang('Store Description (optional)')</label>
												<textarea name="short_description" rows="9"
														  class="h-100 form-control form-control-sm">{{ old('name',$store->short_description) }}</textarea>
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-4">
									<div class="row">
										<div class="col-md-12">
											<div class="input-box form-group">
												<label>@lang('Shipping Charge')</label>
												<div class="selectgroup w-100">
													<label class="selectgroup-item">
														<input type="radio" name="shipping_charge" value="0"
															   class="selectgroup-input" {{$store->shipping_charge == 0 ? 'checked':''}}>
														<span class="selectgroup-button">@lang('OFF')</span>
													</label>
													<label class="selectgroup-item">
														<input type="radio" name="shipping_charge" value="1"
															   class="selectgroup-input" {{$store->shipping_charge == 1 ? 'checked':''}}>
														<span class="selectgroup-button">@lang('ON')</span>
													</label>
												</div>
											</div>
										</div>
									</div>
									<div class="row mt-3">
										<div class="col-md-12">
											<div class="input-box form-group">
												<label>@lang('Delivery Note')</label>
												<div class="selectgroup w-100">
													<label class="selectgroup-item">
														<input type="radio" name="delivery_note" value="Disabled"
															   class="selectgroup-input" {{$store->delivery_note == 'Disabled' ? 'checked':''}}>
														<span class="selectgroup-button">@lang('DISABLED')</span>
													</label>
													<label class="selectgroup-item">
														<input type="radio" name="delivery_note" value="Enable"
															   class="selectgroup-input" {{$store->delivery_note == 'Enable' ? 'checked':''}}>
														<span class="selectgroup-button">@lang('ENABLE')</span>
													</label>
												</div>
											</div>
										</div>
									</div>
									<div class="row mt-3">
										<div class="col-md-12">
											<div class="input-box form-group">
												<label>@lang('Cash On Delivery')</label>
												<div class="selectgroup w-100">
													<label class="selectgroup-item">
														<input type="radio" name="cash_on_delivery" value="0"
															   class="selectgroup-input" {{$store->cash_on_delivery == 0 ? 'checked':''}}>
														<span class="selectgroup-button">@lang('OFF')</span>
													</label>
													<label class="selectgroup-item">
														<input type="radio" name="cash_on_delivery" value="1"
															   class="selectgroup-input" {{$store->cash_on_delivery == 1 ? 'checked':''}}>
														<span class="selectgroup-button">@lang('ON')</span>
													</label>
												</div>
											</div>
										</div>
									</div>
									<div class="row mt-3">
										<div class="col-md-12">
											<div class="input-box form-group">
												<label>@lang('Status')</label>
												<div class="selectgroup w-100">
													<label class="selectgroup-item">
														<input type="radio" name="status" value="0"
															   class="selectgroup-input" {{$store->status == 0 ? 'checked':''}}>
														<span class="selectgroup-button">@lang('OFF')</span>
													</label>
													<label class="selectgroup-item">
														<input type="radio" name="status" value="1"
															   class="selectgroup-input" {{$store->status == 1 ? 'checked':''}}>
														<span class="selectgroup-button">@lang('ON')</span>
													</label>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Save Changes')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection



