@extends(template().'layouts.user')
@section('page_title',__('Create Coupon'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Create Coupon')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.coupon.create') }}" method="post"
							  enctype="multipart/form-data">
							@csrf
							<div class="row mb-3">
								<div class="col-lg-4 input-box">
									<label>@lang('Store')</label>
									<div class="form-group">
										<select class="form-select" name="store" required>
											<option value="" disabled selected>@lang('Select Store')</option>
											@if($stores)
												@foreach($stores as $store)
													<option
														value="{{$store->id}}" {{old('store') == $store->id ? 'selected':''}}>{{$store->name}}</option>
												@endforeach
											@endif
										</select>
										<div class="text-danger">
											@error('store') @lang($message) @enderror
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class="input-box form-group">
										<label for="Coupon Code">@lang('Coupon Code')</label>
										<div class="input-group">
											<input type="text"
												   name="code"
												   value="{{ old('code') }}"
												   class="form-control code"
												   placeholder="@lang('Code')"
												   autocomplete="off" required>
											<button type="button" class="btn-modify" id="generate">
												<span class="">@lang('Generate')</span>
											</button>
										</div>
										<div class="text-danger">
											@error('code') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-lg-4">
									<div class="input-box form-group">
										<label for="Minimum Order">@lang('Minimum Order')</label>
										<div class="input-group">
											<input type="number" step="0.001"
												   name="min_order"
												   value="{{ old('min_order') }}"
												   class="form-control"
												   placeholder="@lang('Min Order')"
												   autocomplete="off" required>
											<button type="button" class="btn-modify">
												<span class="">{{ basicControl()->base_currency }}</span>
											</button>
										</div>
										<div class="text-danger">
											@error('min_order') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row mb-3">
								<div class="col-lg-6">
									<div class="input-box form-group">
										<label for="Start Date">@lang('Start Date')</label>
										<input type="date"
											   name="start_date"
											   min="{{\Carbon\Carbon::now()->toDateString()}}"
											   value="{{ old('start_date') }}"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('start_date') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="End Date">@lang('End Date')</label>
										<input type="date"
											   name="end_date"
											   min="{{\Carbon\Carbon::now()->toDateString()}}"
											   value="{{ old('end_date') }}"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('end_date') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row align-items-center">
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Coupon Code">@lang('Discount Amount')</label>
										<div class="input-group">
											<div class="input-group-prepend">
												<span class="form-control">{{ basicControl()->currency_symbol }}</span>
											</div>
											<input type="number" step="0.001"
												   name="discount_amount"
												   value="{{ old('discount_amount') }}"
												   class="form-control"
												   placeholder="@lang('Discount Amount')"
												   autocomplete="off" required>
											<div class="input-group-append">
												<select name="discount_type"
														class="form-control form-control-sm">
													<option
														value="flat" {{old('discount_type') == 'flat' ? 'selected':''}}>@lang('Fixed')</option>
													<option
														value="percentage" {{old('discount_type') == 'percentage' ? 'selected':''}}>@lang('%')</option>
												</select>
											</div>
										</div>
										<div class="text-danger">
											@error('discount_amount') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label>@lang('Status')</label>
										<div class="selectgroup w-100">
											<label class="selectgroup-item">
												<input type="radio" name="status" value="0"
													   class="selectgroup-input">
												<span class="selectgroup-button">@lang('OFF')</span>
											</label>
											<label class="selectgroup-item">
												<input type="radio" name="status" value="1"
													   class="selectgroup-input" checked>
												<span class="selectgroup-button">@lang('ON')</span>
											</label>
										</div>
									</div>
								</div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Create Coupon')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict';
		$(document).on("click", "#generate", function () {
			let random = (Math.random() + 1).toString(36).substring(6);
			$('.code').val(random);
		})
	</script>
@endpush

