@extends(template().'layouts.user')
@section('page_title',__('Whatsapp Bot'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-md-8">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Whatsapp Bot')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{route('user.store.whatsapp.set',$store->id)}}" method="post"
							  enctype="multipart/form-data">
							@csrf
							<div class="row">
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="SID">@lang('SID')</label>
										<input type="text"
											   name="whatsapp_sid"
											   value="{{old('whatsapp_sid')??$store->whatsapp_sid}}"
											   placeholder="AC7b8086b5b1dbd63361c3d595b80d358e"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('sid') @lang($message) @enderror
										</div>

									</div>
								</div>
								<div class="col-md-6">
									<div class="input-box form-group">
										<label for="Token">@lang('Token')</label>
										<input type="text"
											   name="whatsapp_token"
											   value="{{old('whatsapp_token')??$store->whatsapp_token}}"
											   placeholder="4f928b4215cab30a7b21d3c222663247"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('whatsapp_token') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-md-4">
									<div class="input-box form-group">
										<label for="Business Account">@lang('Business Account')</label>
										<input type="text"
											   name="whatsapp_business_account"
											   value="{{old('whatsapp_business_account')??$store->whatsapp_business_account}}"
											   placeholder="+14185238986"
											   class="form-control"
											   autocomplete="off" required>
										<div class="text-danger">
											@error('whatsapp_business_account') @lang($message) @enderror
										</div>
									</div>
								</div>
								<div class="col-md-8">
									<div class="input-box form-group">
										<label for="Token">@lang('Message Callback URL')</label>
										<div class="input-group">
											<input type="text"
												   value="{{route('whatsappWebhook',$store->link)}}"
												   class="form-control"
												   id="webhook"
												   autocomplete="off" readonly>
											<button type="button" onclick="webhookCopy()"
													class="btn-modify">@lang('copy')</button>
										</div>
									</div>
								</div>

							</div>

							<div class="row mt-3">
								<div class="col-sm-12 col-md-4 input-box">
									<label>@lang('Initiate Image')</label>
									<div class="form-group position-relative">
										<div class="image-input z0">
											<label for="image-upload" id="image-label"><i
													class="fas fa-upload"></i></label>
											<input type="file" id="image" name="whatsapp_bot_image"
												   placeholder="@lang('Choose image')" class="image-preview">
											<img id="image_preview_container" class="preview-image"
												 src="{{ getFile($store->whatsapp_bot_image_driver,$store->whatsapp_bot_image) }}"
												 alt="@lang('preview image')">
										</div>
									</div>
									<div class="text-danger">
										@error('whatsapp_bot_image') @lang($message) @enderror
									</div>

									@if(config("filelocation.whatsappBot"))
										<span
											class="text-warning">{{trans('Image size should be')}} {{config("filelocation.whatsappBot.size")}} {{trans('px')}}</span>
									@endif
								</div>
							</div>

							<div class="row mt-3">
								<div class="col-md-12">
									<div class="input-box form-group">
										<label
											for="Initiate Message">@lang('Initiate Message')</label>
										<textarea name="whatsapp_initiate_message" rows="5"
												  placeholder="@lang('Welcome please open menu and order food from given link')"
												  class="form-control form-control-sm"
												  required>{{old('whatsapp_initiate_message')??$store->whatsapp_initiate_message}}</textarea>
										<div class="text-danger">
											@error('whatsapp_initiate_message') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Create Bot')</button>
						</form>
					</div>
				</section>
			</div>
			<div class="col-md-4 mt-5">
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<div class="row">
							<div class="col-md-12">
								<div class="d-flex justify-content-between">
									<h5>@lang('Instructions')</h5>
									<a href="{{route('user.store.whatsapp.docs')}}" target="_blank" class="btn-modify">@lang('How to set up')</a>
								</div>
							</div>
							<p class="mt-4">
								@lang('Curious to learn how to set up our bot quickly and effortlessly? Click the "How to Set Up" button below to access our comprehensive guide. Inside,')
								@lang("you'll find step-by-step instructions, screenshots, and tips to guide you through the setup process. Don't miss out on this valuable resource – get started now and unleash the full potential of our bot in no time!")
							</p>
						</div>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict';

		$(document).on('change', '.image-preview', function () {
			let reader = new FileReader();
			reader.onload = (e) => {
				$('#image_preview_container').attr('src', e.target.result);
			}
			reader.readAsDataURL(this.files[0]);
		});

		function webhookCopy() {
			var copyText = document.getElementById("webhook");
			copyText.select();
			copyText.setSelectionRange(0, 99999);
			navigator.clipboard.writeText(copyText.value);
			Notiflix.Notify.success(`${copyText.value} Copied`);
		}

		function verify_token_copy() {
			var copyText = document.getElementById("verify_token");
			copyText.select();
			copyText.setSelectionRange(0, 99999);
			navigator.clipboard.writeText(copyText.value);
			Notiflix.Notify.success(`${copyText.value} Copied`);
		}
	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush

