@extends(template().'layouts.store')
@section('page_title',__('Menu List'))

@section('content')
	<section class="food-items">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="heading d-flex justify-content-between">
						<div class="d-flex align-items-center">
							<h4>@lang('Welcome') {{$store->name}}</h4>
						</div>
						@include(template().'partials.user.cart-box')
					</div>
				</div>
				<div class="col-12">
					<form action="{{route('public.view',[$senderId,$link])}}" method="get">
						<div class="search-box">
							<div class="input-group">
								<button type="submit"><i class="fa-regular fa-magnifying-glass"></i></button>
								<input type="text" class="form-control" name="search" value="{{@request()->search}}"
									   placeholder="@lang('search')"/>
							</div>
						</div>
					</form>
				</div>
				@php
					$lastSeg = collect(request()->segments())->last();
				@endphp
				<div class="col-12">
					<div class="categories" id="categories">
						@if($categories)
							<a href="{{route('public.view',[$senderId,$link])}}"
							   class="tab {{($lastSeg == $link) ? 'active':''}}">@lang('All')</a>
							@foreach($categories as $category)
								<a href="{{route('public.view',[$senderId,$link,$category->id])}}"
								   class="tab {{$lastSeg == $category->id ? 'active':''}}">{{$category->name}}</a>
							@endforeach
						@endif
					</div>
				</div>
			</div>

			<div class="row g-3">
				@if($products)
					@foreach($products as  $product)
						<div class="col-lg-2 col-md-4 col-6">
							<div class="menu-box">
								<div class="img-box">
									<img class="img-fluid" src="{{getFile($product->driver,$product->image)}}"
										 alt="{{$product->name}}"/>
								</div>
								<div class="text-box">
									<a href="{{route('public.product.details',[$senderId,$link,slug($product->name),$product->id])}}">{{\Illuminate\Support\Str::limit($product->name,25)}}</a>
									<h5 class="price">{{ currencyPosition(getAmount($product->price)) }}</h5>
								</div>
								<a href="{{route('public.product.details',[$senderId,$link,slug($product->name),$product->id])}}"
								   class="cart-btn">
									<i class="fal fa-angle-double-right"></i>
								</a>
							</div>
						</div>
					@endforeach
				@endif
			</div>
		</div>
	</section>
@endsection
@push('scripts')
	<script>
		'use strict'
		var link = "{{$link}}"
		var clearSession = "{{$clearSession}}"
		if (clearSession) {
			sessionStorage.clear();
		}
		let obj = JSON.parse(sessionStorage.getItem(link));
		if (obj) {
			var countLength = Object.keys(obj).length;
			$("#showCart").text(countLength);
		} else {
			$("#showCart").text(0);
		}
	</script>
@endpush
