@extends(template().'layouts.store')
@section('page_title',__('Cart Update'))
@section('content')
	<section class="food-items">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="heading d-flex justify-content-between">
						<div class="d-flex align-items-center">
							<a href="{{url()->previous()}}" class="back-btn">
								<i class="fa-light fa-chevron-left"></i>
							</a>
							<h4>@lang('Welcome') @lang($store->name)</h4>
						</div>
						@include(template().'partials.user.cart-box')
					</div>
				</div>
			</div>
			<div class="row g-3 justify-content-center">
				<div class="col-lg-4 col-md-6 col-12">
					<div class="menu-details-box">
						<div class="img-box">
							<img class="img-fluid" src="{{getFile($product->driver,$product->image)}}"
								 alt="{{$product->name}}"/>
						</div>
						<div class="text-box">
							<p>@lang($product->description)</p>
							<h4 class="mb-2">@lang($product->name)</h4>
							<h5 class="price mb-3">
								@if($product->variants)
									{{basicControl()->currency_symbol}}
									<span class="showVariantPrice"></span>
								@else
                                    {{basicControl()->currency_symbol}}
									{{$product->price}}
								@endif
							</h5>

							<div class="quantity mb-3">
								<button class="btn-inc-dec decrement">-</button>
								<input type="text" class="form-control counter" value=""
									   readonly/>
								<button class="btn-inc-dec increment">+</button>
							</div>
							@if($product->variants)
								<div class="check-radio-box-wrapper">
									<div class="mt-4">
										<div class="d-flex justify-content-between">
											<h5>@lang('Variation')</h5>
											<p class="price">@lang('Required')</p>
										</div>
										<p class="mb-3">@lang('Select up to '){{count($product->variants)}}</p>
										@foreach($product->variants as $key => $variant)
											<div class="form-check">
												<input class="form-check-input variant"
													   value="{{$variant->variant_price}}"
													   data-variant_name="{{$variant->variant_name}}"
													   type="radio"
													   name="variation"
													   id="variation{{$key}}">
												<label class="form-check-label" for="variation{{$key}}">
													{{$variant->variant_name}}
													<span>+ {{basicControl()->currency_symbol}}{{$variant->variant_price}}</span>
												</label>
											</div>
										@endforeach
									</div>
									@if(count($product->extra_products())>0)
										<div class="mt-4 form-check-with-img">
											<h5>@lang('Add ons') - @lang($product->name)</h5>
											<p class="mb-3">@lang('Select up to '){{count($product->extra_products())}}</p>
											@foreach($product->extra_products() as $key => $addOn)
												<div class="form-check">
													<input class="form-check-input ads_Checkbox"
														   name="extra_products[]"
														   type="checkbox" value="{{$addOn->id}}"
														   id="add-ons{{$key}}">
													<label class="form-check-label" for="add-ons{{$key}}">
											<span>
											   <img class="img-fluid rounded-circle"
													src="{{getFile($addOn->driver,$addOn->image)}}"
													alt="{{$addOn->name}}">
											   {{$addOn->name}}
											</span>
														<span>+ {{basicControl()->currency_symbol}}{{$addOn->price}}</span>
													</label>
												</div>
											@endforeach
										</div>
									@endif
								</div>
							@endif
							<div class="bottom-area">
								<button type="button" class="btn-custom updateCart">@lang('Update cart')</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
@endsection
@push('scripts')
	<script>
		'use strict'
		var senderId = "{{$senderId}}"
		var productId = "{{$product->id}}"
		var storeId = "{{$store->id}}"
		var link = "{{$store->link}}"
		var isVariant = "{{empty($product->variants)}}"
		var carts = JSON.parse(sessionStorage.getItem(link));

		if (carts) {
			var countLength = Object.keys(carts).length;
			$("#showCart").text(countLength);
		} else {
			$("#showCart").text(0);
		}

		var i = 0;
		for (const item of carts) {
			if (item.productId == productId) {
				var productCart = item;
				var id = i
				var variantPrice = item.variantPrice;
				var addons = item.extra_products ?? [];
			}
			i++
		}

		$('.showVariantPrice').text(variantPrice);
		$('.counter').val(productCart.quantity);
		$(`input[name=variation][value="${variantPrice}"]`).prop("checked", true);
		if (0 < addons.length) {
			addons.map(function (obj, i) {
				$(`.ads_Checkbox[value="${obj}"]`).attr('checked', 'checked');
			});
		}

		$(document).on("click", ".variant", function () {
			var variantPrice = $(this).val();
			$('.showVariantPrice').text(variantPrice)
		});

		$(document).on("click", ".increment", function () {
			let value = $('.counter').val();
			$(".counter").val(parseInt(value) + 1);
		});

		$(document).on("click", ".decrement", function () {
			let value = $('.counter').val();
			if (parseInt(value) > 1) {
				$(".counter").val(parseInt(value) - 1);
			}
		});

		$(document).on("click", ".updateCart", function () {

			var variantPrice = $("input[name='variation']:checked").val();
			var variantName = $("input[name='variation']:checked").data('variant_name');

			var extra_products = [];
			var i = 0;
			$('.ads_Checkbox:checked').each(function () {
				extra_products[i++] = $(this).val();
			});

			if (!isVariant && !variantPrice) {
				Notiflix.Notify.Failure("@lang('Please Select a Variation')");
			}
			var counter = $('.counter').val();
			addCart(counter, extra_products, variantPrice, variantName);
		});

		function addCart(counter = 1, extra_products = [], variantPrice = null, variantName = null) {
			$.ajax({
				url: "{{ route('public.update.cartDetails') }}",
				method: "post",
				data: {
					senderId: senderId,
					items: JSON.parse(sessionStorage.getItem(link)),
					id: id,
					storeId: storeId,
					productId: productId,
					counter: counter,
					extra_products: extra_products,
					variantPrice: variantPrice,
					variantName: variantName,
					link: link,
				},
				success: function (res) {
					if (res.status == 'success') {
						sessionStorage.clear()
						sessionStorage.setItem(link, JSON.stringify(res.item));
						window.location.href = res.url;
					} else {
						Notiflix.Notify.failure("@lang('Something Went Wrong Please Try Again')");
					}
				}
			});
		}

	</script>

	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{ trans($error) }}");
			@endforeach
		</script>
	@endif
@endpush

