@extends(template().'layouts.user')
@section('page_title',trans('Profile'))
@section('content')
    <div class="container-fluid">
        <div class="main row">
            <div class="col-12">
                <div class="dashboard-heading">
                    <h4 class="mb-0">@lang('Profile Settings')</h4>
                </div>
                <section class="profile-setting">
                    <div class="row g-4 g-lg-5">
                        <div class="col-lg-4">
                            <div class="sidebar-wrapper">
                                <form action="{{ route('user.profile.update.image')}}" method="post"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="profile mb-3">
                                        <div class="img">
                                            <img id="profile"
                                                 src="{{ getFile($user->image_driver, $user->image) }}"
                                                 alt="" class="img-fluid"/>
                                            <button class="upload-img">
                                                <i class="fal fa-camera"></i>
                                                <input
                                                    class="form-control"
                                                    name="image"
                                                    accept="image/*"
                                                    type="file"
                                                    onchange="previewImage('profile')"
                                                />
                                            </button>
                                            <div class="d-block mt-1">
                                                <button type="submit" class="btn-modify">@lang('Update')</button>
                                            </div>
                                        </div>
                                        <div class="text">
                                            <h5 class="name">@lang(ucwords($user->firstname. ' ' . $user->lastname))</h5>
                                            <span>@lang('@'.$user->username)</span>
                                        </div>
                                    </div>
                                </form>
                                <div class="profile-navigator mt-5">
                                    <button tab-id="tab1"
                                            class="tab {{ $errors->has('profile') ? 'active' : (($errors->has('password')) || $errors->has('identity') ? '' : 'active') }}">
                                        <i class="fal fa-user"></i> @lang('Profile Information')
                                    </button>
                                    <button tab-id="tab2" class="tab {{ $errors->has('password') ? 'active' : '' }}">
                                        <i class="fal fa-key"></i> @lang('Password Setting')
                                    </button>
                                    <button tab-id="tab3" class="tab {{ $errors->has('identity') ? 'active' : '' }}">
                                        <i class="fal fa-badge-check"></i> @lang('Identity verification')
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div id="tab1"
                                 class="content {{ $errors->has('profile') ? ' active' : (($errors->has('password')) | $errors->has('identity') ? '' :  ' active') }}">
                                <form action="{{ route('user.profile.update')}}" method="post"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row g-4">
                                        <div class="input-box col-md-6">
                                            <label for="">@lang('First Name')</label>
                                            <input type="text" class="form-control" name="first_name"
                                                   value="{{ old('first_name', $user->firstname) }}"
                                                   placeholder="Mr. John" autocomplete="off"/>
                                            @if($errors->has('first_name'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('first_name')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang('Last Name')</label>
                                            <input type="text" class="form-control" name="last_name"
                                                   value="{{ old('last_name', $user->lastname) }}"
                                                   placeholder="Doe" autocomplete="off"/>
                                            @if($errors->has('last_name'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('last_name')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang('username')</label>
                                            <input type="text" class="form-control" name="username"
                                                   value="{{ old('username', $user->username) }}"
                                                   placeholder="johndoe" autocomplete="off"/>
                                            @if($errors->has('username'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('username')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang('Email Address')</label>
                                            <input type="email" class="form-control" name="email"
                                                   value="{{ old('email', $user->email) }}"
                                                   placeholder="example@gmail.com" autocomplete="off" readonly/>
                                            @if($errors->has('email'))
                                                <div class="error text-danger">@lang($errors->first('email')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang('Phone Number')</label>
                                            <input type="text" class="form-control" name="phone"
                                                   value="{{ old('phone', $user->phone) }}"
                                                   placeholder="Enter phone number" autocomplete="off" readonly/>
                                            @if($errors->has('phone'))
                                                <div class="error text-danger">@lang($errors->first('phone')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang('Preferred language')</label>
                                            <select class="js-example-basic-single form-control" name="language_id">
                                                <option value="" disabled>@lang('Select Language')</option>
                                                @foreach($languages as $la)
                                                    <option value="{{$la->id}}"
                                                        {{ old('language_id', $user->language_id) == $la->id ? 'selected' : '' }}>@lang($la->name)</option>
                                                @endforeach
                                            </select>
                                            @if($errors->has('language_id'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('language_id')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-12">
                                            <label for="">@lang('Address One')</label>
                                            <input class="form-control" name="address_one" value="{{old('address_one')?: $user->address_one }}"
                                                      placeholder="@lang('Address One')">
                                            @if($errors->has('address_one'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('address_one')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-12">
                                            <label for="">@lang('Address Two')</label>
                                            <input class="form-control" name="address_two" value="{{old('address_two')?: $user->address_two }}"
                                                   placeholder="@lang('Address Two')">
                                            @if($errors->has('address_two'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('address_two')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-12">
                                            <button class="btn-custom">@lang('submit')</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div id="tab2" class="content {{ $errors->has('password') ? 'active' : '' }}">
                                <form action="{{ route('user.updatePassword') }}" method="post">
                                    @csrf
                                    <div class="row g-4">
                                        <div class="input-box col-md-6">
                                            <label for="">@lang("Current Password")</label>
                                            <input type="password" name="current_password" class="form-control" value="{{ old('current_password') }}"
                                                   placeholder=""/>
                                            @if($errors->has('current_password'))
                                                <div
                                                    class="error text-danger">@lang($errors->first('current_password')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang("New Password")</label>
                                            <input type="password" name="password" class="form-control" value="{{ old('password') }}"
                                                   placeholder=""/>
                                            @if($errors->has('password'))
                                                <div class="text-danger">@lang($errors->first('password')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-md-6">
                                            <label for="">@lang("Confirm Password")</label>
                                            <input type="password" name="password_confirmation" class="form-control" value="{{ old('password_confirmation') }}"
                                                   placeholder=""/>
                                            @if($errors->has('password_confirmation'))
                                                <div
                                                    class="text-danger">@lang($errors->first('password_confirmation')) </div>
                                            @endif
                                        </div>
                                        <div class="input-box col-12">
                                            <button type="submit" class="btn-custom">@lang('Change Password')</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="tab3" class="content {{ $errors->has('identity') ? 'active' : '' }}">
                                @if(!empty($identityFormList) && count($identityFormList) > 0)
                                    @if(isset($submissionStatus))
                                        <div class="alert alert-primary" role="alert">
                                            <span>@lang($submissionStatus)</span>
                                        </div>
                                    @endif
                                    <form method="post" action="{{ route('user.kyc.verification.submit') }}" enctype="multipart/form-data">
                                        @csrf
                                        <div class="input-box mt-4">
                                            <label>@lang('Identity Type')</label>
                                            <select class="js-example-basic-single form-control" name="type" id="identity_type" style="height: 100%">
                                                <option value="" disabled selected>@lang('Select Identity Type')</option>
                                                @foreach($identityFormList as $sForm)
                                                    <option value="{{$sForm->slug}}" {{ old('identity_type', @$identity_type) == $sForm->slug ? 'selected' : '' }}> @lang($sForm->name) </option>
                                                @endforeach
                                            </select>
                                            @if($errors->has('identity_type'))
                                                <div class="error text-danger">@lang($errors->first('current_password')) </div>
                                            @endif
                                        </div>
                                        @if(isset($identityForm))
                                            @foreach($identityForm->input_form as $k => $v)
                                                @if($v->type == "text")
                                                    <div class="input-box mt-4">
                                                        <label for="{{$k}}">
                                                            {{trans($v->field_label)}}
                                                            @if($v->validation == 'required')
                                                                <span class="text-danger">*</span>
                                                            @endif
                                                        </label>
                                                        <input type="text" name="{{$k}}"
                                                               class="form-control"
                                                               placeholder="@lang('Enter '.$v->field_label)"
                                                               value="{{old($k)}}" id="{{$k}}"
                                                               @if($v->validation == 'required') required @endif/>
                                                        @if($errors->has($k))
                                                            <div
                                                                class="error text-danger">@lang($errors->first($k))</div>
                                                        @endif
                                                    </div>

                                                @elseif($v->type == "textarea")
                                                    <div class="input-box mt-4">
                                                        <label for="{{$k}}">
                                                            {{trans($v->field_label)}}
                                                            @if($v->validation == 'required')
                                                                <span class="text-danger">*</span>
                                                            @endif
                                                        </label>
                                                        <textarea
                                                            name="{{$k}}"
                                                            id="{{$k}}"
                                                            class="form-control"
                                                            cols="30"
                                                            rows="3"
                                                            placeholder="{{trans('Type Here')}}"
                                                        @if($v->validation == 'required')@endif>{{old($k)}}</textarea>
                                                        @error($k)
                                                        <div class="error text-danger">
                                                            {{trans($message)}}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                @elseif($v->type == "file")

                                                    <div class="input-box mt-4">
                                                        <label>{{trans($v->field_label)}} @if($v->validation == 'required')<span class="text-danger">*</span>  @endif
                                                        </label>
                                                        <div>
                                                            <img id="{{$k}}"
                                                                 src="{{ getFile(config('filelocation.default')) }}"
                                                                 alt="" class="img-fluid" width="150px" height="150px"/>
                                                            <button class="upload-img">
                                                                <input
                                                                    class="form-control"
                                                                    name="{{$k}}"
                                                                    accept="image/*"
                                                                    type="file" @if($v->validation == "required")@endif
                                                                    onchange="previewImage('{{$k}}')"
                                                                />
                                                            </button>
                                                            @if ($errors->has($k))
                                                                <br>
                                                                <span class="text-danger">{{ __($errors->first($k)) }}</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                        @endif
                                        <div class="input-box mt-4 col-12">
                                            <button type="submit" class="btn-custom">@lang('Submit')</button>
                                        </div>
                                    </form>
                                @else
                                    <div class="alert mb-0 py-3 text-center">
                                        <span> @lang('Identity verification not required')</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        "use strict";
        $(document).ready(function() {
            $('.tab').on('click', function(e) {
                e.preventDefault();
                $('.tab').removeClass('active');
                $('.content').removeClass('active');
                $(this).addClass('active');
                var tabId = $(this).attr('tab-id');
                $('#' + tabId).addClass('active');

                var url = new URL(window.location.href);
                url.searchParams.delete('identity_type');
                window.history.pushState({}, '', url);
            });

            $(document).on('change', "#identity_type", function () {
                let value = $(this).find('option:selected').val();
                window.location.href = "{{route('user.profile')}}/?identity_type=" + value;
            });
        });

    </script>
@endpush
