@extends(template().'layouts.user')
@section('page_title',__('Order Details'))

@section('content')
	<section class="profile-setting">
		<div class="container-fluid">
			<div class="main row">
				<div class="col-12">
					<div class="dashboard-heading">
						<h2 class="mb-0">@lang('Order-'){{$order->order_number}}</h2>
					</div>
					<div class="row">
						<div class="col-md-8">
							<div class="table-responsive">
								<table
									class="table table-striped table-hover align-items-center table-flush">
									<thead class="thead-light">
									<tr>
										<th>@lang('SL.')</th>
										<th>@lang('Item Name')</th>
										<th>@lang('Add Ons')</th>
										<th>@lang('Price')</th>
										<th>@lang('Quantity')</th>
										<th>@lang('Total Price')</th>
									</tr>
									</thead>
									<tbody>
									@forelse($order->details as $key => $item)
										<tr>
											<td data-label="@lang('SL.')">
												{{1 + $key++}}</td>
											<td data-label="Item Name">
												<a href="javascript:void(0)"
												   class="text-decoration-none">
													<div class="d-lg-flex d-block align-items-center ">
														<div class="mr-3"><img
																src="{{getFile(optional($item->product)->driver,optional($item->product)->image)}}"
																alt="user" class="rounded-circle"
																width="40" data-toggle="tooltip">
														</div>
														<div
															class="d-inline-flex d-lg-block align-items-center ms-2">
															<p class="text-dark mb-0 font-16 font-weight-medium">
																{{$item->variant_name??$item->product_name}}</p>
															<span
																class="text-muted font-14 ml-1">{{optional($item->product)->sku}}</span>
														</div>
													</div>
												</a>
											</td>
											<td data-label="@lang('Add Ons')">
												@if(count($item->extra_products())>0)
													@foreach($item->extra_products() as $addon)
														<a href="{{route('user.store.menu.optional.edit',$addon->id)}}" target="_blank"><span
																class="custom-badge color-info mb-1">{{ $addon->name }}-({{ currencyPosition(getAmount($addon->price)) }})</span></a>
													@endforeach
												@else
													-
												@endif
											</td>
											<td data-label="Price">{{ currencyPosition(getAmount($item->price)) }}</td>
											<td data-label="Quantity">{{$item->quantity}}</td>
											<td data-label="Total Price">{{ currencyPosition(getAmount($item->total_price)) }}</td>
										</tr>
									@empty
                                        <tr class="text-center">
                                            <th class="text-center" colspan="100%">
                                                <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                                <p class="mt-3">@lang('No data available')</p>
                                            </th>
                                        </tr>
									@endforelse
									</tbody>
								</table>
							</div>
						</div>
						<div class="col-md-4 mt-3">
							<div class="row">
								<div class="col-md-12">
									<div class="sidebar-wrapper">
										<div class="d-flex justify-content-between align-items-center mb-2">
											<h5>@lang('Delivery Details')</h5>
											<div class="sidebar-dropdown-items">
												<button
													type="button"
													class="dropdown-toggle customButton"
													data-bs-toggle="dropdown"
													aria-expanded="false">
													<i class="fal fa-cog"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="javascript:void(0)" class="dropdown-item changeClick"
														   data-bs-toggle="modal"
														   data-bs-target="#stageChange" data-stage="In Process"> <i
																class="fal fa-spinner"></i> @lang('In Process') </a>
													</li>
													<li>
														<a href="javascript:void(0)" class="dropdown-item changeClick"
														   data-bs-toggle="modal"
														   data-bs-target="#stageChange" data-stage="Out For Delivery">
															<i
																class="fal fa-hiking"></i> @lang('Out For Delivery')
														</a>
													</li>
													<li>
														<a href="javascript:void(0)"
														   class="dropdown-item changeClick" data-bs-toggle="modal"
														   data-bs-target="#stageChange" data-stage="Delivered"> <i
																class="fal fa-handshake-alt"></i> @lang('Delivered')
														</a>
													</li>
													<li>
														<a href="javascript:void(0)"
														   class="dropdown-item changeClick" data-bs-toggle="modal"
														   data-bs-target="#stageChange" data-stage="Cancel"> <i
																class="fal fa-times"></i> @lang('Cancel') </a>
													</li>
												</ul>
											</div>
										</div>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Order Date') }}</span>
											<span>{{dateTime($order->created_at,'d/M/Y H:i')??'N/A'}}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Payment Type') }}</span>
											@if($order->gateway_id == 0)
												<span
													class="text-dark font-weight-bold">@lang('Cash On Delivery')</span>
											@else
												<span class="text-dark font-weight-bold">@lang('Automatic')</span>
											@endif
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Status') }}</span>
											@if($order->gateway_id == 0 && $order->stage != 1)
												<span class="custom-badge color-warning">@lang('Unpaid')</span>
											@else
												<span class="custom-badge color-success">@lang('Paid')</span>
											@endif
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Stage') }}</span>
											@if($order->stage == 0)
												<span class="custom-badge color-warning">@lang('New Arrive')</span>
											@elseif($order->stage == 1)
												<span class="custom-badge color-success">@lang('Delivered')</span>
											@elseif($order->stage == 2)
												<span class="custom-badge color-info">@lang('In Process')</span>
											@elseif($order->stage == 3)
												<span
													class="custom-badge color-purple">@lang('Out For Delivery')</span>
											@elseif($order->stage == 4)
												<span
													class="custom-badge color-danger">@lang('Cancel')</span>
											@endif
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Full Name') }}</span>
											<span>{{$order->full_name??'N/A'}}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Email') }}</span>
											<span>{{$order->email??'N/A'}}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Phone') }}</span>
											<span>{{$order->phone??'N/A'}}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Alt. Phone') }}</span>
											<span>{{$order->alt_phone??'N/A'}}</span>
										</li>
										@if($order->shipping_id )
											<li class="list-group-item d-flex justify-content-between">
												<span>{{ __('Shipping Address') }}</span>
												<span>{{optional($order->shipping)->address??'N/A'}}</span>
											</li>
										@endif
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Details Address') }}</span>
											<span class="ms-2">{{$order->detailed_address??'N/A'}}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Total Amount') }}</span>
											<span>{{currencyPosition(getAmount($order->total_amount,2))}} </span>
										</li>
										@if($order->shipping_charge > 0)
											<li class="list-group-item d-flex justify-content-between text-danger">
												<span>{{ __('Shipping Charge') }}</span>
												<span>{{ currencyPosition(getAmount($order->shipping_charge)) }}</span>
											</li>
										@endif
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Discount') }}</span>
											<span>{{ currencyPosition(getAmount($order->discount_amount)) }}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between text-success">
											<span>{{ __('Payment Amount') }}</span>
											<span>{{ currencyPosition(getAmount($order->payment_amount)) }}</span>
										</li>
										<li class="list-group-item d-flex justify-content-between">
											<span>{{ __('Delivery Note') }}</span>
											<span class="ms-2">{{$order->delivery_note??'N/A'}}</span>
										</li>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<div class="modal fade" id="stageChange" tabindex="-1" aria-labelledby="stageChange" aria-hidden="true">
		<div class="modal-dialog modal-dialog-top modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="stageChange">@lang('Stage Change Confirmation')</h5>
					<button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
						<i class="fal fa-times"></i>
					</button>
				</div>
				<div class="modal-body">
					<div class="row g-4">
						<p id="msgShow"></p>
					</div>
				</div>
				<div class="modal-footer">
					<form action="{{route('user.order.single.stage.change',$order->id)}}" method="post">
						@csrf
						<input type="hidden" name="stage" class="stage" value="">
						<button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
						<button type="submit" class="btn-custom">@lang('Yes')</button>
					</form>
				</div>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict'
		$(document).on('click', '.changeClick', function () {
			let stage = $(this).data('stage');
			$('#msgShow').text(`Are You Sure To Change This Stage ${stage}`)
			$('.stage').val(stage);
		});
	</script>
@endpush
