
@if(!empty($feature))
    @php
        $multiple = $feature['multiple']->sortBy(function ($item) {
            return $item->get('order_by');
        });
    @endphp
    <section class="feature-section">
        <div class="container">
            <div class="row g-4">
                @foreach($multiple as $item)
                    <div class="col-lg-4 col-md-6">
                        <div class="feature-box">
                            <div class="icon-box">
                                <img src="{{ getFile($item['media']->image->driver, $item['media']->image->path) }}"
                                    alt="image"/>
                            </div>
                            <div class="text-box">
                                <h4>@lang($item['title'] ?? '')</h4>
                                <p>@lang($item['description'] ?? '')</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            @if(!empty($feature['single']))
                <div class="row mt-5">
                    <div class="col">
                        <div class="alert text-center">
                            <p>@lang($feature['single']['heading'] ?? '')</p>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
@endif

