
@if(!empty($blog))
	<section class="blog-section {{ getLastSegment() == 'Blogs' ? 'blog-page' : '' }}">
		<div class="container">
			@if(!empty($blog['single']) && getLastSegment() != 'Blogs')
				<div class="row">
					<div class="col-12">
						<div class="header-text text-center">
							<h5>@lang($blog['single']['heading'] ?? '')</h5>
							<h2>@lang($blog['single']['title'] ?? '')</h2>
						</div>
					</div>
				</div>
			@endif
			<div class="row g-4">
                @foreach($blog['blogs']->take(3) as $item)

                    <div class="col-lg-4">
                        <div class="blog-box">
                            <div class="img-box">
                                <img src="{{ getFile($item->blog_image_driver,$item->blog_image) }}" class="img-fluid" alt="image">
                            </div>
                            <div class="text-box">
                                <a href="{{ route('blog.details', optional($item->details)->slug) }}" class="title">@lang(optional($item->details)->title)</a>
                                <div class="date-author">
                                    <span>@lang(dateTime($item->created_at,'d M, Y'))</span>
                                </div>
                                <p>@lang(strip_tags(Str::limit(optional($item->details)->description,170)))</p>
                                <a href="{{ route('blog.details', optional($item->details)->slug) }}" class="read-more">@lang('read more')</a>
                            </div>
                        </div>
                    </div>
                @endforeach
			</div>
            @if(getLastSegment() == 'Blogs')
                <div class="row">
                    <div class="col">
                        <nav aria-label="Page navigation example">
                            <ul class="pagination justify-content-center">
                                {{ $blog['blogs']->appends($_GET)->links(template().'partials.pagination') }}
                            </ul>
                        </nav>
                    </div>
                </div>
            @endif
		</div>
	</section>
@endif


