
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<style>
		*{
			font-family:"DeJaVu Sans Mono",monospace;
		}
	</style>
	<title>@lang('Order Receipt')</title>
</head>
<body style="font-size: 15px; margin: 0; padding: 0; color: #2f2d52">
<div class="invoice" style="margin: auto; padding: 30px; background-color: #fff">
	<!-- header -->
	<div style="border-bottom: 1px solid #e5e5e5; width: 100%; position: relative; height: 85px">
		<div style="width: 50%; position: absolute; left: 0; top: 0">
			<h2 style="font-size: 36px; color: #feba27; margin: 15px 0 0 0">{{$storeName}}</h2>
		</div>
		<div style="width: 50%; position: absolute; right: 0; top: 0; text-align: right">
			<h4 style="font-size: 24px; margin: 0 0 15px 0">@lang('Order Receipt')</h4>
			<p><strong>@lang('Order Number'):</strong> {{$orderNumber}}</p>
		</div>
	</div>


	<div class="card" style="border: 1px solid rgba(0, 0, 0, 0.125); margin-top: 20px">
		<table
			class="table"
			style="
                  color: #333;
                  vertical-align: top;
                  border-color: #dee2e6;
                  caption-side: bottom;
                  border-collapse: collapse;
                  width: 100%;
               "
		>
			<thead class="card-header" style="background-color: #333; border-bottom: 1px solid #00000020">
			<tr>
				<td style="padding: 10px">
					<h3 style="margin: 0; color: #fff;">Paid {{$paidType}}</h3>
				</td>
				<td style="padding: 10px; text-align: right">
					<h3 width="50" style="margin: 0; color: #fff;">{{$gateway}}</h3>
				</td>
			</tr>
			</thead>
			<tbody>
			<tr>
				<td style="padding: 10px; border-bottom: 1px solid #fff">
					@lang('DATE') {{$orderDate}}
				</td>
			</tr>
			</tbody>
		</table>
	</div>

	<div class="card" style="border: 1px solid rgba(0, 0, 0, 0.125); margin-top: 20px">
		<table
			class="table"
			style="
                  color: #333;
                  vertical-align: top;
                  border-color: #dee2e6;
                  caption-side: bottom;
                  border-collapse: collapse;
                  width: 100%;
               "
		>
			<thead class="card-header" style="background-color: #333; border-bottom: 1px solid #00000020">
			<tr>
				<td style="padding: 10px">
					<h3 style="margin: 0; color: #fff;">Delivery</h3>
				</td>
				<td style="padding: 10px; text-align: right; color: #fff;">{{$deliveryAddress}}</td>
			</tr>
			</thead>
			<tbody>
			<tr>
				<td colspan="2" style="padding: 10px; border-bottom: 1px solid #fff">
					<p style="margin-bottom: 5px">{{$detailsAddress}}</p>
					{{$deliveryNote}}
				</td>
			</tr>
			</tbody>
		</table>
	</div>


	<div class="card">
		<h3>@lang('Client Info'):</h3>
		<div style="margin-bottom: 5px">@lang('Full Name'): <span style="float: right;">{{$fullName}}</span></div>
		<div style="margin-bottom: 5px">@lang('Email'): <span style="float: right;">{{$email}}</span></div>
		<div style="margin-bottom: 5px">@lang('Phone'): <span style="float: right;">{{$phone}}</span></div>
	</div>

	@if($orderNote)
		<h4><img width="20" style="margin-bottom: -4px"
				 src="{{asset($themeTrue.'images/comment.png')}}"
				 alt=""> {{$orderNote}}</h4>
	@endif

	<h3>Item:</h3>
	<div class="card" style="border: 1px solid rgba(0, 0, 0, 0.125)">
		<div class="card-body">
			<div class="table-responsive">
				<table
					class="table"
					style="
                        color: #333;
                        vertical-align: top;
                        border-color: #dee2e6;
                        caption-side: bottom;
                        border-collapse: collapse;
                        width: 100%;
                     "
				>
					<thead class="card-header" style="background-color: #f1f2f6; border-bottom: 1px solid #00000020">
					<tr>
						<td style="padding: 10px">
							<strong>@lang('Description')</strong>
						</td>
						<td style="padding: 10px">
							<strong>@lang('Quantity')</strong>
						</td>
						<td style="padding: 10px; text-align: right">
							<strong>@lang('Amount')</strong>
						</td>
					</tr>
					</thead>
					<tbody>
					@if($items)
						@foreach($items as $item)
							<tr>
								<td style="padding: 10px; border-bottom: 1px solid #00000020">
									{{$item->variant_name??$item->product_name}}
									@if(count($item->extra_products())>0)
										-
										@foreach($item->extra_products() as $addon)
											{{$addon->name}},
										@endforeach
									@endif
								</td>
								<td style="padding: 10px; border-bottom: 1px solid #00000020">{{$item->quantity}}</td>
								<td style="padding: 10px; border-bottom: 1px solid #00000020; text-align: right">{{$currencySymbol}}{{$item->total_price}}</td>
							</tr>
						@endforeach
					@endif
					</tbody>
				</table>
			</div>
		</div>
	</div>


	<div class="card" style="border-top: 1px solid #00000020; padding-top: 20px">
		<h4 style="margin: 10px 0">@lang('Subtotal'): <span
				style="float: right;">{{$currencySymbol}}{{$subtotal}}</span>
		</h4>
		<h4 style="margin: 10px 0">@lang('Delivery fee'): <span
				style="float: right;">{{$currencySymbol}}{{$deliveryFee}}</span>
		</h4>
		<h4 style="margin: 10px 0">@lang('Discount'): <span
				style="float: right;">{{$currencySymbol}}{{$discount}}</span></h4>
		<h4 style="margin: 10px 0">@lang('Total') <span
				style="float: right;">{{$currencySymbol}}{{$paymentAmount}}</span></h4>
	</div>
</div>
</body>
</html>
