<!-- sidebar -->
<div id="sidebar" class="">
    <div class="sidebar-top">
        <a class="navbar-brand" href="{{url('/')}}"> <img
                src="{{ getFile(basicControl()->logo_driver, basicControl()->logo) }}"
                alt="{{ basicControl()->site_title }}"/></a>
        <button class="sidebar-toggler d-md-none" onclick="toggleSideMenu()">
            <i class="fal fa-times"></i>
        </button>
    </div>
    <ul class="main">
        <li>
            <a class="{{ menuActive('user.dashboard') }}" href="{{ route('user.dashboard') }}"><i
                    class="fal fa-th-large text-red"></i>@lang("Dashboard")</a>
        </li>

        <li>
            <a class="{{ menuActive(['user.store.list','user.store.create','user.store.edit','user.store.telegram.set','user.store.messenger.set','user.store.whatsapp.set','user.store.command.set'
                    ,'user.store.command.edit','user.store.qr.code']) }}"
               href="{{ route('user.store.list') }}"><i class="fal fa-store text-purple"></i>@lang('Store List')</a>
        </li>

        <li>
            <a class="{{ menuActive('user.store.schedules') }}" href="{{ route('user.store.schedules') }}"><i
                    class="fal fa-clock text-pink"></i>@lang('Opening Schedule')</a>
        </li>

        <li>
            <a class="{{ menuActive('user.store.category.index') }}" href="{{ route('user.store.category.index') }}"><i
                    class="fal fa-stream text-red"></i>@lang('Food Category')</a>
        </li>

        <li>
            <a class="dropdown-toggle {{ menuActive(['user.store.menu.index','user.store.menu.optional.index','user.store.menu.optional.create','user.store.menu.optional.edit','user.store.menu.index','user.store.menu.create','user.store.menu.edit']) }}"
               data-bs-toggle="collapse"
               href="#dropdownCollapsible2"
               role="button"
               aria-expanded="false"
               aria-controls="collapseExample">
                <i class="fal fa-cutlery text-yellow"></i>@lang('Menu Item')
            </a>
            <div
                class="collapse dropdownCollapsible {{ request()->routeIs('user.store.menu.optional.index','user.store.menu.index') ? 'show' : '' }}"
                id="dropdownCollapsible2">
                <ul class="">
                    <li>
                        <a class="{{ menuActive(['user.store.menu.optional.index','user.store.menu.optional.create']) }}"
                           href="{{ route('user.store.menu.optional.index') }}"><i
                                class="fa fa-arrow-right"></i>@lang('Optional Menu')
                        </a>
                    </li>
                    <li>
                        <a class="{{ menuActive(['user.store.menu.index','user.store.menu.create']) }}"
                           href="{{ route('user.store.menu.index') }}"><i
                                class="fa fa-arrow-right"></i>@lang('Menu List')</a>
                    </li>
                </ul>
            </div>
        </li>

        <li>
            <a class="{{ menuActive('user.store.shipping.index') }}" href="{{ route('user.store.shipping.index') }}"><i
                    class="fal fa-shipping-fast text-green"></i>@lang('Shipping List')</a>
        </li>

        <li>
            <a class="{{ menuActive(['user.store.coupon.index','user.store.coupon.create','user.store.coupon.edit']) }}"
               href="{{ route('user.store.coupon.index') }}"><i class="fal fa-barcode-scan text-teal"></i>@lang('Coupon List')</a>
        </li>

        <li>
            @php
                $orderParameter = ['order','new-arrivals','in-process','out-for-delivery','delivered','cancel'];
                $currentSlug = slug(getLastSegment());
            @endphp
            <a
                class="dropdown-toggle {{menuActive(['user.order.index'])}}"
                data-bs-toggle="collapse"
                href="#dropdownCollapsible3"
                role="button"
                aria-expanded="false"
                aria-controls="collapseExample">
                <i class="fal fa-tags text-cyan"></i>@lang('Orders')
            </a>
            <div class="collapse dropdownCollapsible {{ in_array($currentSlug, $orderParameter) ? 'show' : '' }}"
                 id="dropdownCollapsible3">
                <ul class="">
                    <li>
                        <a href="{{route('user.order.index')}}" class="{{ $currentSlug == 'order' ? 'active' : '' }}"><i
                                class="fa fa-arrow-right"></i>@lang('All Orders')
                        </a>
                    </li>
                    <li>
                        <a class="{{ $currentSlug == 'new-arrivals' ? 'active' : '' }}"
                           href="{{route('user.order.index','new-arrivals')}}"><i
                                class="fa fa-arrow-right"></i>@lang('New Arrivals')</a>
                    </li>
                    <li>
                        <a class="{{ $currentSlug == 'in-process' ? 'active' : '' }}"
                           href="{{route('user.order.index','in-process')}}"><i
                                class="fa fa-arrow-right"></i>@lang('In Process')</a>
                    </li>
                    <li>
                        <a class="{{ $currentSlug == 'out-for-delivery' ? 'active' : '' }}"
                           href="{{route('user.order.index','out-for-delivery')}}"><i
                                class="fa fa-arrow-right"></i>@lang('Out For Delivery')</a>
                    </li>
                    <li>
                        <a class="{{ $currentSlug == 'delivered' ? 'active' : '' }}"
                           href="{{route('user.order.index','delivered')}}"><i
                                class="fa fa-arrow-right"></i>@lang('Delivered')
                        </a>
                    </li>
                    <li>
                        <a class="{{ $currentSlug == 'cancel' ? 'active' : '' }}"
                           href="{{route('user.order.index','cancel')}}"><i
                                class="fa fa-arrow-right"></i>@lang('Cancel')</a>
                    </li>
                </ul>
            </div>
        </li>

        <li>
            <a class="{{ menuActive('user.transactions') }}" href="{{ route('user.transactions') }}"><i
                    class="fal fa-file-spreadsheet text-gray"></i>@lang('Transactions')</a>
        </li>

        <li>
            <a class="{{ menuActive('user.purchase.plan.list') }}" href="{{ route('user.purchase.plan.list') }}"><i
                    class="fal fa-cubes text-orange"></i>@lang('Purchase Plan')</a>
        </li>

        <li>
            <a class="{{ menuActive(['user.payment.gateway.index','user.payment.gateway.edit']) }}"
               href="{{ route('user.payment.gateway.index') }}"><i class="fal fa-sack-dollar text-cyan"></i>@lang('Payment Gateways')
            </a>
        </li>

        <li>
            <a href="{{ route('user.ticket.list') }}"
               class="{{ menuActive(['user.ticket.list','user.ticket.create','user.ticket.view']) }}"><i
                    class="fas fa-ticket text-indigo"></i>@lang('Support Ticket')</a>
        </li>
        <li>
            <a class="{{ menuActive('user.notification.permission') }}"
               href="{{ route('user.notification.permission') }}"><i
                    class="fal fa-bullhorn text-pink"></i>@lang('Notification Permission')</a>
        </li>

        <li>
            <a href="{{ route('user.twostep.security') }}" class="{{ menuActive('user.twostep.security') }}"><i
                    class="fal fa-lock text-orange"></i>@lang('2FA Security')</a>
        </li>
    </ul>
</div>
