<!DOCTYPE html>
<html lang="en" @if(session()->get('rtl') == 1) dir="rtl" @endif />
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">
	<title> @lang("Messenger Configuration") | {{basicControl()->site_title}} </title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css')}}"/>

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/fontawesome.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/animate.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.carousel.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.theme.default.min.css')}}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/style.css')}}"/>
    @stack('css-lib')
    @stack('style')
</head>

<body>

<div id="app">
	<div class="dashboard-wrapper">
		<!-- sidebar -->
		<div id="sidebar" class="">
			<div class="sidebar-top">
                <a class="navbar-brand" href="{{url('/')}}"> <img
                        src="{{ getFile(basicControl()->logo_driver, basicControl()->logo) }}"
                        alt="{{ basicControl()->site_title }}"/></a>
				<button class="sidebar-toggler d-md-none" onclick="toggleSideMenu()">
					<i class="fal fa-times"></i>
				</button>
			</div>
			<ul class="main">
				<li>
					<a class="{{menuActive('user.store.list')}}" href="{{route('user.store.list')}}"><i
							class="fal fa-arrow-left"></i>@lang("Back")</a>
				</li>

				<li>
					<a class="" href="#Facebook_Developer_Account">
						<i class="fab fa-facebook"></i>@lang("FB Developer Account")</a>
				</li>

				<li>
					<a class="" href="#Create_a_New_App">
						<i class="fa fa-rocket"></i>@lang("Create a New App")</a>
				</li>
				<li>
					<a class="" href="#Set_Up_Messenger">
						<i class="fab fa-facebook-messenger"></i>@lang("Set Up Messenger")</a>
				</li>

				<li>
					<a class="" href="#Configure_Webhook">
						<i class="fab fa-connectdevelop"></i>@lang("Configure Webhook")</a>
				</li>

				<li>
					<a class="" href="#Deploy_Bot_Server">
						<i class="fas fa-robot"></i>@lang("Deploy Bot Server")</a>
				</li>

				<li>
					<a class="" href="#Connect_Bot_to_Webhook">
						<i class="fas fa-link"></i>@lang("Connect Bot to Webhook")</a>
				</li>

				<li>
					<a class="" href="#Enable_Live_Mode">
						<i class="fas fa-signal-stream"></i>@lang("Enable Live Mode")</a>
				</li>

				<li>
					<a class="" href="#Test_and_Launch">
						<i class="fas fa-rocket-launch"></i>@lang("Test and Launch")</a>
				</li>
			</ul>
		</div>

	<!-- content -->
		<div id="content">
			<div class="overlay">
                @include(template().'partials.user.topbar')
				<div class="container-fluid">
					<div class="main row doc-content">
						<div class="col-12">
							<div id="Facebook_Developer_Account" class="padding">
								<h4 class="mt-3">@lang("Facebook Developer Account")</h4>
								<ul>
									<li>@lang("If you don't have one already, create a Facebook Developer account by visiting the Facebook Developer website") (<a
											href="https://developers.facebook.com" target="_blank">https://developers.facebook.com</a>).
									</li>
									<li>@lang("Log in to your Facebook Developer account using your Facebook credentials.")
									</li>
								</ul>
							</div>

							<div id="Create_a_New_App" class="padding">
								<h4 class="mt-3">@lang("Create a New App")</h4>
								<ul>
									<li>@lang('Once logged in, navigate to the "My Apps" section and click on "Create App."')

									</li>
									<li>@lang("Provide a unique name for your app and select the appropriate category.")

									</li>
									<li>@lang("Follow the on-screen instructions to create your app.")

									</li>
								</ul>
							</div>

							<div id="Set_Up_Messenger" class="padding">
								<h4 class="mt-3">@lang("Set Up Messenger")</h4>
								<ul>
									<li>
										@lang('In your app dashboard, locate the "Messenger" tab and click on it.')
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/01.png')}}" class="w-75" alt="">
										</div>
										<br>
									</li>
									<li>@lang('Set up a new Messenger product by clicking on the "Set Up" button.')
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/02.png')}}" class="w-75" alt="">
										</div>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/03.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>
									<li>
										@lang('Configure the basic settings, such as selecting the Facebook page associated with the bot and generating a page access token.')
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/04.png')}}" class="w-75" alt="">
										</div>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/05.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>
								</ul>
							</div>

							<div id="Configure_Webhook" class="padding">
								<h4 class="mt-3">@lang('Configure Webhook')</h4>
								<ul>
									<li>
										@lang('In the Messenger settings, scroll down to the "Webhooks" section and click on the "Setup Webhooks" button.')

										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/06.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>

									<li class="mt-3">@lang("Enter the URL where your bot's server will receive messages (typically your server's endpoint URL).")
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/07-min.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>

									<li class="mt-3">
										@lang("Copy and paste verify token what is provide from store  and save it for future reference.")
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/07.png')}}" class="w-50" alt="">
										</div>
										<br>
									</li>
									<li class="mt-3">
										@lang("Select the desired subscription fields based on the events you want the bot to receive (e.g., messages, postbacks).")
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/08.png')}}" class="w-50" alt="">
										</div>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/09.png')}}" class="w-50" alt="">
										</div>
									</li>
									<li>
										@lang("Save the webhook settings.")
									</li>
								</ul>
							</div>

							<div class="padding" id="Deploy_Bot_Server">
								<h4 class="mt-3">@lang("Deploy Bot Server")</h4>
								<ul>
									<li>
										@lang("Set up the server environment required to host your bot's backend code. This typically involves installing and configuring a web server, such as Apache or Nginx, and a programming language environment, such as Node.js or Python.")</li>

									<li>@lang("Follow the instructions provided with the source code to install any necessary dependencies and configure the bot's settings.")</li>
								</ul>
							</div>

							<div class="padding" id="Connect_Bot_to_Webhook">
								<h4 class="mt-3">@lang("Connect Bot to Webhook")</h4>
								<ul>
									<li>@lang("Update the bot's server code with the page access token and verify token you generated earlier.")
									</li>

									<li>@lang("Verify that your server is accessible via the URL you provided in the webhook settings.")
									</li>
								</ul>
							</div>

							<div class="padding" id="Enable_Live_Mode">
								<h4 class="mt-3">@lang("Enable Live Mode")</h4>
								<ul>
									<li class="mt-3">
										@lang('Before sending App Review request, you need to select for enable "page_messaging" Access.')
										<br>
										<br>
										<div class="code-block ">
											<img src="{{asset($themeTrue.'images/messenger/12.png')}}" class="w-75" alt="">
										</div>
										<br>
									</li>
									<li>@lang("Ensure that your Facebook page has the bot messaging feature enabled in Live Mode. This allows you to interact with users and prompt them to leave app reviews.")
									</li>
                                    <div class="code-block ">
                                        <img src="{{asset($themeTrue.'images/messenger/13.png')}}" class="w-75" alt="">
                                    </div>
								</ul>
							</div>
							<div class="padding" id="Test_and_Launch">
								<h4 class="mt-3">@lang("Test and Launch")</h4>
								<ul>
									<li>@lang("Open the Facebook page associated with your bot and send a message to initiate a conversation with the bot.")
									</li>
									<li>@lang("Test various functionalities and interactions of your bot to ensure everything is working as expected.")
									</li>
									<li>@lang("Once you're satisfied with the bot's performance, promote it to a wider audience by sharing your Facebook page and encouraging users to engage with the bot.")
									</li>
								</ul>
							</div>

							<p>
								@lang("That's it! You've successfully set up your Facebook Messenger bot. Remember to monitor the bot's performance, address any issues or user feedback promptly, and continue optimizing the bot to provide a seamless experience for your audience.")
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script src="{{ asset($themeTrue . 'js/bootstrap.bundle.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/jquery.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/owl.carousel.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/qrjs2.min.js')}}"></script>
<script src="{{ asset($themeTrue . 'js/socialSharing.js')}}"></script>
<script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
<script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
<script src="{{ asset($themeTrue . 'js/script.js')}}"></script>

<script src="{{ asset('assets/global/js/pusher.min.js') }}"></script>
<script src="{{ asset('assets/global/js/vue.min.js') }}"></script>
<script src="{{ asset('assets/global/js/axios.min.js') }}"></script>

@if(session()->has('success'))
    <script>
        Notiflix.Notify.success("@lang(session('success'))");
    </script>
@endif
@if(session()->has('error'))
    <script>
        Notiflix.Notify.failure("@lang(session('error'))");
    </script>
@endif

@stack('script')
</body>
</html>
