<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <meta content="{{ isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : '' }}" name="description">
        <meta content="{{ is_array(@$pageSeo['meta_keywords']) ? implode(', ', @$pageSeo['meta_keywords']) : @$pageSeo['meta_keywords'] }}"
              name="keywords">
        <meta name="theme-color" content="{{ basicControl()->primary_color }}">
        <meta name="author" content="{{basicControl()->site_title}}">
        <meta name="robots" content="{{ isset($pageSeo['meta_robots']) ? $pageSeo['meta_robots'] : '' }}">

        <meta property="og:type" content="website">
        <meta property="og:site_name" content="{{ isset(basicControl()->site_title) ? basicControl()->site_title : '' }}">
        <meta property="og:title" content="{{ isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : '' }}">
        <meta property="og:description" content="{{ isset($pageSeo['og_description']) ? $pageSeo['og_description'] : '' }}">
        <meta property="og:image" content="{{ @$pageSeo['meta_image'] }}">

        <meta name="twitter:card" content="{{ isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : '' }}">
        <meta name="twitter:title" content="{{ isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : '' }}">
        <meta name="twitter:description" content="{{ isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : '' }}">
        <meta name="twitter:image" content="{{ @$pageSeo['meta_image'] }}">

        <title> {{basicControl()->site_title}} @if(isset($pageSeo['page_title']))
                | {{str_replace(basicControl()->site_title, ' ',$pageSeo['page_title'])}}
            @else
                 | @yield('title')
            @endif</title>

        <!-- Favicons -->
        <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">

        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/fontawesome.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/animate.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.carousel.min.css')}}"/>
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/owl.theme.default.min.css')}}"/>
        <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">
        @stack('css-lib')
        @stack('style')
        @laravelPWA
        <link rel="stylesheet" href="{{ asset($themeTrue . 'css/style.css')}}"/>
    </head>

    <body>
        @include($theme.'partials.nav')
        @include($theme.'partials.bottom_nav')
        @include($theme.'partials.banner')

        @yield('content')

        @if(basicControl()->cookie_status == 1)
            @include(template().'partials.cookie')
        @endif
        @include($theme.'partials.footer')
        @include(template().'partials.pwa')

        <script src="{{ asset($themeTrue . 'js/bootstrap.bundle.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/jquery.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/owl.carousel.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/qrjs2.min.js')}}"></script>
        <script src="{{ asset($themeTrue . 'js/socialSharing.js')}}"></script>
        <script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
        <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
        <script src="{{ asset($themeTrue . 'js/script.js')}}"></script>
        @stack('js-lib')
        @stack('script')

        @if (session()->has('success'))
            <script>
                Notiflix.Notify.success("@lang(session('success'))");
            </script>
        @endif
        @if (session()->has('error'))
            <script>
                Notiflix.Notify.failure("@lang(session('error'))");
            </script>
        @endif
        @if (session()->has('warning'))
            <script>
                Notiflix.Notify.warning("@lang(session('warning'))");
            </script>
        @endif
    </body>
</html>


