@extends(template().'layouts.app')
@section('title',trans('Blog Details'))
@section('content')
    <section class="blog-page blog-details">
        <div class="container">
            <div class="row g-lg-5">
                <div class="col-lg-8">
                    <div class="blog-box">
                        <div class="img-box">
                            <img src="{{ getFile(optional($blogDetails->blog)->blog_image_driver, optional($blogDetails->blog)->blog_image) }}"/>
                        </div>
                        <div class="text-box">
                            <div class="date-author">
                                <span>@lang(dateTime($blogDetails->created_at))</span>
                            </div>
                            <h5 class="title">@lang($blogDetails->title)</h5>
                            <div class="text-justify">
                                @lang($blogDetails->description)
                            </div>
                            <div class="social-share-box">
                                <h4 class="title">@lang('Share') :</h4>
                                <div id="shareBlock"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="side-bar">
                        @if (!empty($relatedBlogs))
                            <div class="side-box">
                                <h4>@lang('Related Posts')</h4>
                                @foreach ($relatedBlogs as $data)
                                    <div class="blog-box">
                                        <div class="img-box">
                                            <img class="img-fluid"
                                                 src="{{ getFile($data->blog_image_driver,$data->blog_image) }}"
                                                 alt="image"/>
                                        </div>
                                        <div class="text-box">
                                            <span class="date">@lang(dateTime($data->created_at,'d M, Y'))</span>
                                            <a href="{{ route('blog.details', optional($data->details)->slug) }}" class="title"
                                            >@lang(optional($data->details)->title)
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
