@extends(template().'layouts.app')
@section('title',trans('Login'))
@section('content')

    <section id="login" class="login-section">
        <div class="container">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-6">
                    <form action="{{ route('login') }}" method="post" class="php-email-form">
                        @csrf
                        <div class="row gy-3">
                            <div class="col-12">
                                <h4>@lang('Login To Your Account')</h4>
                            </div>
                            <div class="input-box col-12">
                                <input type="text" class="form-control @error('username') is-invalid @enderror" name="username" value="{{ old('username', config('demo.IS_DEMO') ? (request()->username ?? 'demouser') : '') }}" placeholder="Username or Email">
                                @error('username')
                                <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="input-box col-12">
                                <input type="password" name="password" class="form-control @error('password') is-invalid @enderror"  value="{{ old('password', config('demo.IS_DEMO') ? (request()->password ?? 'demouser') : '') }}" placeholder="Password">
                                @error('password')
                                <span class="invalid-feedback d-block" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            @if(basicControl()->manual_recaptcha == 1 && basicControl()->manual_recaptcha_login == 1)
                                <div class="row mt-3">
                                    <div class="input-box col-8">
                                        <input type="text" tabindex="2"
                                               class="form-control form-control-lg @error('captcha') is-invalid @enderror"
                                               name="captcha" id="captcha" autocomplete="off"
                                               placeholder="Enter Captcha" required>
                                        @error('captcha')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="input-box col-4 d-flex align-items-center" data-hs-validation-validate-class>
                                        <img src="{{route('captcha').'?rand='. rand()}}" id='captcha_image'>
                                        <a class="btn" href='javascript: refreshCaptcha();'><i class="fad fa-sync"></i></a>
                                    </div>
                                </div>
                            @endif

                            @if(basicControl()->google_recaptcha == 1 && basicControl()->google_recaptcha_login == 1)
                                <div class="col-12">
                                    <div class="g-recaptcha @error('g-recaptcha-response') is-invalid @enderror" data-sitekey="{{ env('GOOGLE_RECAPTCHA_SITE_KEY') }}"></div>
                                    @error('g-recaptcha-response')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </div>
                            @endif

                            <div class="col-12">
                                <div class="links mb-0">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="remember" {{ old('remember') ? 'checked' : '' }}/>
                                        <label class="form-check-label" for="remember"> @lang('Remember Me') </label>
                                    </div>
                                    @if (Route::has('password.request'))
                                        <a href="{{ route('password.request') }}">@lang('Forgot Your Password')?</a>
                                    @endif
                                </div>
                            </div>

                            <button type="submit" class="btn-custom w-100">@lang('Sign In')</button>
                            <div class="bottom mt-2">
                                @lang("Don't have an account?")
                                <a href="{{ route('register') }}">@lang('Create account')</a>
                            </div>
                            @if(config('socialite.google_status') || config('socialite.facebook_status') || config('socialite.github_status'))
                                <hr class="divider mt-5 langActive">
                                <div class="social-login mt-2">
                                    @if(config('socialite.google_status'))
                                        <a href="{{ route('socialiteLogin','google') }}">
                                            <i class="fab fa-google"></i>
                                        </a>
                                    @endif

                                    @if(config('socialite.facebook_status'))
                                        <a href="{{ route('socialiteLogin','facebook') }}">
                                            <i class="fab fa-facebook"></i>
                                        </a>
                                    @endif

                                    @if(config('socialite.github_status'))
                                        <a href="{{ route('socialiteLogin','github') }}">
                                            <i class="fab fa-github"></i>
                                        </a>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js-lib')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endpush
@push('script')
    <script>
        function refreshCaptcha() {
            let img = document.images['captcha_image'];
            img.src = img.src.substring(
                0, img.src.lastIndexOf("?")
            ) + "?rand=" + Math.random() * 1000;
        }
    </script>
@endpush
