<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->nullable();
            $table->foreignId('gateway_id')->index()->nullable();
            $table->foreignId('store_id')->index()->nullable();
            $table->foreignId('user_id')->index()->nullable()->comment('who owner of store');
            $table->string('full_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('detailed_address')->nullable();
            $table->foreignId('shipping_id')->index()->nullable();
            $table->double('shipping_charge')->default(0);
            $table->string('alt_phone')->nullable();
            $table->longText('delivery_note')->nullable();
            $table->text('order_note')->nullable();
            $table->double('total_amount')->default(0);
            $table->double('discount_amount')->default(0);
            $table->double('payment_amount')->default(0);
            $table->tinyInteger('status')->default(0)->comment("0=>pending,1=>complete (Payment Status)");
            $table->tinyInteger('stage')->default(0)->comment("0=>arrive,1=>delivery done, 2=>in process, 3=>out for delivery, 4=>cancel");
            $table->string('utr')->nullable();
            $table->string('sender_id')->nullable();
            $table->string('bot_type')->nullable();
            $table->tinyInteger('is_transaction')->default(0)->comment('cash on delivery transaction created (0=>no , 1=>yes)');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
