<?php

namespace App\Services;

use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\File;

class SendWhatsappMessageService
{
    protected $twilio;


    public function sendOrderMessageWithPDF($order)
    {
        try {
            $sid = optional($order->store)->whatsapp_sid;
            $token = optional($order->store)->whatsapp_token;
            $ownerNumber = $order->user->phone_code . $order->user->phone_code;
            $storeOwnerWhatsAppNum = optional($order->store)->whatsapp_business_account;

            $twilio = new Client($sid, $token);
            $twilio->messages->create(
                "whatsapp:" . $ownerNumber, // Recipient WhatsApp number
                [
                    "from" => "whatsapp:" . $storeOwnerWhatsAppNum,
                    "body" => "Here is your order invoice PDF.",
                    "mediaUrl" => route('downloadPdf', ['orderId' => $order ? $order->id : '0']),
                ]
            );
        } catch (\Exception $e) {
            return false;
        }

    }

}
