<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class StoreProductOptional extends Model
{
    protected $table = 'store_product_optionals';
    protected $guarded = ['id'];

    public function scopeOwn($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function extra_products()
    {
        $products = StoreProduct::get();
        if ($products) {
            foreach ($products as $product) {
                $exit = in_array($this->id, $product->extra_products);
                if ($exit) {
                    return true;
                }
            }
        }
        return false;
    }

    public static function boot(): void
    {
        parent::boot();
        static::saved(function () {
            Cache::forget('storeProductOptionalRecord');
        });
    }
}
