<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class StoreCategory extends Model
{
    protected $table = 'store_categories';
    protected $guarded = ['id'];

    public function scopeOwn($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function activeProducts()
    {
        return $this->hasMany(StoreProduct::class, 'category_id')->where('status', 1);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function products()
    {
        return $this->hasMany(StoreProduct::class, 'category_id');
    }

    public static function boot(): void
    {
        parent::boot();
        static::saved(function () {
            Cache::forget('storeCategoryRecord');
        });
    }
}
