<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    use HasFactory;

    protected $table = 'schedules';
    protected $guarded = ['id'];

    public function details()
    {
        return $this->hasOne(ScheduleDetails::class);
    }

    public function plans()
    {
        return $this->hasMany(PlanSchedule::class, 'schedule_id')->orderBy('plan_id');
    }
}
