<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchasePlan extends Model
{
    protected $table = 'purchase_plans';
    protected $guarded = ['id'];

    public function scopeOwn($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, 'plan_id');
    }

    public function schedule()
    {
        return $this->belongsTo(Schedule::class, 'schedule_id');
    }

    public function deposit(){
        return $this->belongsTo(Deposit::class, 'deposit_id');
    }

    public function gateway()
    {
        return $this->belongsTo(Gateway::class, 'gateway_id', 'id');
    }

    public function userGateway()
    {
        return $this->belongsTo(UserGateway::class, 'gateway_id', 'id');
    }

    public function transactional()
    {
        return $this->morphOne(Transaction::class, 'transactional');
    }
}
