<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Plan extends Model
{
    use HasFactory;

    protected $table = 'plans';
    protected $guarded = ['id'];

    public function details()
    {
        return $this->hasOne(PlanDetails::class);
    }

    public function planSchedules()
    {
        return $this->hasMany(PlanSchedule::class, 'plan_id');
    }

}
