<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderDetail extends Model
{
    use HasFactory;
    protected $table = 'order_details';
    protected $guarded = ['id'];

    protected $casts = [
        'extra_products' => 'array'
    ];

    public function product()
    {
        return $this->belongsTo(StoreProduct::class, 'product_id');
    }

    public function extra_products()
    {
        return StoreProductOptional::whereIn('id', $this->extra_products)->get();
    }
}
