<?php

namespace App\Jobs;

use App\Models\SupportTicket;
use App\Traits\Upload;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class UserAllRecordDeleteJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Upload;

    public $userId;

    /**
     * Create a new job instance.
     */
    public function __construct($userId)
    {
        $this->userId = $userId;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        DB::table('deposits')->where('user_id', $this->userId)->delete();
        DB::table('purchase_plans')->where('user_id', $this->userId)->delete();
        DB::table('transactions')->where('user_id', $this->userId)->delete();
        DB::table('user_gateways')->where('user_id', $this->userId)->delete();
        DB::table('user_kycs')->where('user_id', $this->userId)->delete();
        DB::table('user_logins')->where('user_id', $this->userId)->delete();

        DB::table('opening_schedules')->where('user_id', $this->userId)->delete();

        DB::table('order_details')->where('order_id', function ($query){
            $query->select('id')->from('orders')->where('user_id', $this->userId);
        })->delete();
        DB::table('orders')->where('user_id', $this->userId)->delete();

        DB::table('store_categories')->where('user_id', $this->userId)->delete();
        DB::table('store_coupons')->where('user_id', $this->userId)->delete();

        DB::table('store_products')->where('user_id', $this->userId)->get()->map(function ($item) {
            if ($item->image) {
                $this->fileDelete($item->driver, $item->image);
            }
        });
        DB::table('store_product_optionals')->where('user_id', $this->userId)->get()->map(function ($item) {
            if ($item->image) {
                $this->fileDelete($item->driver, $item->image);
            }
        });

        DB::table('store_shippings')->where('user_id', $this->userId)->delete();

        DB::table('stores')->where('user_id', $this->userId)->get()->map(function ($item) {
            if ($item->telegram_bot_image) {
                $this->fileDelete($item->telegram_bot_image_driver, $item->telegram_bot_image);
            }
            if ($item->messenger_bot_image) {
                $this->fileDelete($item->messenger_bot_image_driver, $item->messenger_bot_image);
            }
            if ($item->whatsapp_bot_image) {
                $this->fileDelete($item->whatsapp_bot_image_driver, $item->whatsapp_bot_image);
            }
        });

        SupportTicket::where('user_id', $this->userId)->get()->map(function ($item) {
            $item->messages()->get()->map(function ($message) {
                if (count($message->attachments) > 0) {
                    foreach ($message->attachments as $img) {
                        $this->fileDelete($img->driver, $img->file);
                        $img->delete();
                    }
                }
            });
            $item->messages()->delete();
            $item->delete();
        });

        DB::table('notification_permissions')->where('notifyable_id', $this->userId)->where('notifyable_type','App\Models\User')->delete();
        DB::table('in_app_notifications')->where('in_app_notificationable_id', $this->userId)->where('in_app_notificationable_type','App\Models\User')->delete();
    }
}
