<?php

namespace App\Http\Controllers;

use App\Models\Store;
use Illuminate\Http\Request;

class WhatsappNotificationController extends Controller
{
	public function reply(Request $request, $link)
	{
		$store = Store::where('status', 1)->where('link', $link)->first();
		$senderId = $request['From'];
        info($senderId);
		$command = str_replace(['<', '>'], ['&#60;', '&#62;'], $request['Body']);

		if ($command == '/menu' || $command == '/start') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getMenu($store, $senderId);
			return $data;

		} elseif ($command == '/lastorder') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getLastOrder($store, $senderId);
			return $data;

		} elseif ($command == '/totalorders') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getTotalOrders($store, $senderId);
			return $data;

		} elseif ($command == '/lastorderstatus') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getLastOrderStatus($store, $senderId);
			return $data;

		} elseif ($command == '/totalorderamount') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getTotalorderAmount($store, $senderId);
			return $data;

		} elseif ($command == '/last10transaction') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getLast10Transaction($store, $senderId);
			return $data;

		} elseif ($command == '/help') {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::getHelp($store, $senderId);
			return $data;

		} else {

			$telegramObj = 'App\\Services\\WhatsappServices';
			$data = $telegramObj::unrecognized($store, $senderId);
			return $data;
		}
	}
}
