<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\BlogDetails;
use App\Models\Content;
use App\Models\Page;
use App\Models\PageDetail;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function blogDetails($slug)
    {
        $pageSeo = Page::where('template_name', getTheme())->where('slug', 'blog-details')->first();
        $pageSeo['breadcrumb_image'] = $pageSeo?->breadcrumb_status == 1 ?  getFile($pageSeo->breadcrumb_image_driver, $pageSeo->breadcrumb_image) : null;
        $blogDetails = BlogDetails::with(['blog:id,category_id,blog_image,blog_image_driver,status,created_at'])
            ->where('slug', $slug)
            ->first();

        if ($blogDetails) {
            $categoryId = $blogDetails->blog->category_id ?? null;
            if ($categoryId) {
                $relatedBlogs = Blog::with('details')->select('id', 'category_id', 'blog_image', 'blog_image_driver', 'status', 'created_at')
                    ->where('category_id', $categoryId)
                    ->where('id', '!=', $blogDetails->blog_id)
                    ->latest()
                    ->get();
                $data['relatedBlogs'] = $relatedBlogs;
            }
        }
        $data['blogDetails'] = $blogDetails;
        return view(template().'blog_details', $data, compact('pageSeo'));
    }
}
