<?php
/**
 * IdentityChangeWhatsAppApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Utils;
use GuzzleHttp\RequestOptions;
use Infobip\ApiException;
use Infobip\Configuration;
use Infobip\HeaderSelector;
use Infobip\ObjectSerializer;

/**
 * IdentityChangeWhatsAppApi Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */
class IdentityChangeWhatsAppApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
    * @param ClientInterface $client
    * @param Configuration   $config
    * @param HeaderSelector  $selector
    */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation confirmWhatsappIdentity
     *
     * Confirm identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppIdentityConfirmation $whatsAppIdentityConfirmation whatsAppIdentityConfirmation (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function confirmWhatsappIdentity($sender, $userNumber, $whatsAppIdentityConfirmation)
    {
        $this->confirmWhatsappIdentityWithHttpInfo($sender, $userNumber, $whatsAppIdentityConfirmation);
    }

    /**
     * Operation confirmWhatsappIdentityWithHttpInfo
     *
     * Confirm identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppIdentityConfirmation $whatsAppIdentityConfirmation (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function confirmWhatsappIdentityWithHttpInfo($sender, $userNumber, $whatsAppIdentityConfirmation)
    {
        $request = $this->confirmWhatsappIdentityRequest($sender, $userNumber, $whatsAppIdentityConfirmation);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->confirmWhatsappIdentityResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->confirmWhatsappIdentityApiException($e);
        }
    }

    /**
     * Operation confirmWhatsappIdentityAsync
     *
     * Confirm identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppIdentityConfirmation $whatsAppIdentityConfirmation (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function confirmWhatsappIdentityAsync($sender, $userNumber, $whatsAppIdentityConfirmation)
    {
        return $this->confirmWhatsappIdentityAsyncWithHttpInfo($sender, $userNumber, $whatsAppIdentityConfirmation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation confirmWhatsappIdentityAsyncWithHttpInfo
     *
     * Confirm identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppIdentityConfirmation $whatsAppIdentityConfirmation (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function confirmWhatsappIdentityAsyncWithHttpInfo($sender, $userNumber, $whatsAppIdentityConfirmation)
    {
        $request = $this->confirmWhatsappIdentityRequest($sender, $userNumber, $whatsAppIdentityConfirmation);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->confirmWhatsappIdentityResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->confirmWhatsappIdentityApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'confirmWhatsappIdentity'
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppIdentityConfirmation $whatsAppIdentityConfirmation (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function confirmWhatsappIdentityRequest($sender, $userNumber, $whatsAppIdentityConfirmation)
    {
        // verify the required parameter 'sender' is set
        if ($sender === null || (is_array($sender) && count($sender) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sender when calling confirmWhatsappIdentity'
            );
        }
        // verify the required parameter 'userNumber' is set
        if ($userNumber === null || (is_array($userNumber) && count($userNumber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $userNumber when calling confirmWhatsappIdentity'
            );
        }
        // verify the required parameter 'whatsAppIdentityConfirmation' is set
        if ($whatsAppIdentityConfirmation === null || (is_array($whatsAppIdentityConfirmation) && count($whatsAppIdentityConfirmation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppIdentityConfirmation when calling confirmWhatsappIdentity'
            );
        }

        $resourcePath = '/whatsapp/1/{sender}/contacts/{userNumber}/identity';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';



        // path params
        if ($sender !== null) {
            $resourcePath = str_replace(
                '{' . 'sender' . '}',
                ObjectSerializer::toPathValue($sender),
                $resourcePath
            );
        }
        // path params
        if ($userNumber !== null) {
            $resourcePath = str_replace(
                '{' . 'userNumber' . '}',
                ObjectSerializer::toPathValue($userNumber),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppIdentityConfirmation)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppIdentityConfirmation));
            } else {
                $httpBody = $whatsAppIdentityConfirmation;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'confirmWhatsappIdentity'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of , HTTP status code, HTTP response headers (array of strings)
     */
    protected function confirmWhatsappIdentityResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'confirmWhatsappIdentity'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function confirmWhatsappIdentityApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation getWhatsappIdentity
     *
     * Get identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppIdentityInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function getWhatsappIdentity($sender, $userNumber)
    {
        list($response) = $this->getWhatsappIdentityWithHttpInfo($sender, $userNumber);
        return $response;
    }

    /**
     * Operation getWhatsappIdentityWithHttpInfo
     *
     * Get identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppIdentityInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWhatsappIdentityWithHttpInfo($sender, $userNumber)
    {
        $request = $this->getWhatsappIdentityRequest($sender, $userNumber);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->getWhatsappIdentityResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->getWhatsappIdentityApiException($e);
        }
    }

    /**
     * Operation getWhatsappIdentityAsync
     *
     * Get identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWhatsappIdentityAsync($sender, $userNumber)
    {
        return $this->getWhatsappIdentityAsyncWithHttpInfo($sender, $userNumber)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWhatsappIdentityAsyncWithHttpInfo
     *
     * Get identity
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWhatsappIdentityAsyncWithHttpInfo($sender, $userNumber)
    {
        $request = $this->getWhatsappIdentityRequest($sender, $userNumber);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->getWhatsappIdentityResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->getWhatsappIdentityApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'getWhatsappIdentity'
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  string $userNumber End user&#39;s number. Must be in international format. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getWhatsappIdentityRequest($sender, $userNumber)
    {
        // verify the required parameter 'sender' is set
        if ($sender === null || (is_array($sender) && count($sender) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sender when calling getWhatsappIdentity'
            );
        }
        // verify the required parameter 'userNumber' is set
        if ($userNumber === null || (is_array($userNumber) && count($userNumber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $userNumber when calling getWhatsappIdentity'
            );
        }

        $resourcePath = '/whatsapp/1/{sender}/contacts/{userNumber}/identity';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';



        // path params
        if ($sender !== null) {
            $resourcePath = str_replace(
                '{' . 'sender' . '}',
                ObjectSerializer::toPathValue($sender),
                $resourcePath
            );
        }
        // path params
        if ($userNumber !== null) {
            $resourcePath = str_replace(
                '{' . 'userNumber' . '}',
                ObjectSerializer::toPathValue($userNumber),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'getWhatsappIdentity'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppIdentityInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function getWhatsappIdentityResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppIdentityInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'getWhatsappIdentity'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function getWhatsappIdentityApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
