@extends(template().'layouts.user')
@section('page_title',__('Payment Gateway'))

@section('content')
	<div id="category">
		<div class="container-fluid">
			<div class="main row">
				<div class="col-12">
					<div class="dashboard-heading">
						<h2 class="mb-0">@lang('Payment Gateway')</h2>
                        <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
					</div>
					<div class="table-parent table-responsive">
						<table
							class="table table-striped">
							<thead class="thead-light">
							<tr>
								<th>@lang('SL.')</th>
								<th>@lang('Name')</th>
								<th>@lang('Gateway Currencies')</th>
								<th>@lang('Supported Currency')</th>
								<th>@lang('Status')</th>
								<th>@lang('Action')</th>
							</tr>
							</thead>
							<tbody id="sortable-table" class="js-sortable">
							@forelse($gateways as $key => $item)
								<tr data-id="{{ $item->id }}">
									<td data-label="@lang('SL.')">{{++$key}}</td>
                                    <td data-label="Name">
                                        <a href="javascript:void(0)"
                                           class="text-decoration-none">
                                            <div class="d-lg-flex align-items-center text-end text-md-start">
                                                <div class="mr-3">
                                                    <img src="{{getFile($item->driver,$item->image)}}"
                                                        alt="user" class="rounded-circle"
                                                        width="40" height="40" data-toggle="tooltip"
                                                        title=""
                                                        data-original-title="{{ucwords($item->name)}}">
                                                </div>
                                                <div
                                                    class="d-inline-flex d-lg-block align-items-center ms-2">
                                                    <p class="text-dark mb-0 font-16 font-weight-medium">@lang(ucwords($item->name))</p>
                                                </div>
                                            </div>
                                        </a>
                                    </td>
									<td data-label="@lang('Gateway Currencies')">
                                        <span class="badge2">{{ $item->countGatewayCurrency() }}</span>
                                    </td>
									<td data-label="@lang('Supported Currency')">
                                        <span class="badge2">{{ count($item->supported_currency ?? 0) }}</span>
                                    </td>
									<td data-label="@lang('Status')">
										@if($item->status == 1)
											<span class="badge bg-success">@lang('Active')</span>
										@else
											<span class="badge bg-danger">@lang('Inactive')</span>
										@endif
									</td>
									<td data-label="Action">
										<div class="sidebar-dropdown-items">
											<button
												type="button"
												class="dropdown-toggle customButton"
												data-bs-toggle="dropdown"
												aria-expanded="false">
												<i class="fal fa-cog"></i>
											</button>
											<ul class="dropdown-menu dropdown-menu-end">
												<li>
													<a href="{{ route('user.payment.gateway.edit', $item->id) }}" class="dropdown-item"> <i class="fal fa-edit"></i> @lang('Edit') </a>
												</li>
												<li>
													<button class="dropdown-item deleteBtn" type="button"
															data-bs-target="#categoryDelete"
															data-bs-toggle="modal"
															data-route="{{route('user.payment.gateway.delete',$item->id)}}">
														<i class="fal fa-trash text-danger"></i> @lang('Delete')
													</button>
												</li>
											</ul>
										</div>
									</td>
								</tr>
							@empty
                                <tr class="text-center">
                                    <th class="text-center" colspan="100%">
                                        <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                        <p class="mt-3">@lang('No data available')</p>
                                    </th>
                                </tr>
							@endforelse
							</tbody>
						</table>
					</div>
                    <nav aria-label="Page navigation example">
                        <ul class="pagination justify-content-center">
                            {{ $gateways->appends($_GET)->links(template().'partials.pagination') }}
                        </ul>
                    </nav>
				</div>
			</div>
		</div>

        <div id="categoryDelete" class="modal fade" data-backdrop="static" tabindex="-1" aria-labelledby="editModalLabel"
             aria-hidden="true">
            <div class="modal-dialog modal-dialog-top modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"
                            id="primary-header-modalLabel">@lang('Delete Confirmation')</h4>
                        <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
                            <i class="fal fa-times"></i>
                        </button>
                    </div>
                    @csrf
                    <div class="modal-body">
                        <p>@lang('Are you want to delete this Gateway?')</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn-custom btn2"
                                data-bs-dismiss="modal">@lang('Close')</button>
                        <form action="" method="post" class="deleteForm">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn-custom">@lang('Yes')</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Name')" name="name" value="{{ request()->name ?? '' }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('js-lib')
    <script src="{{ asset('assets/admin/js/sortable.min.js') }}"></script>
@endpush

@push('script')
	<script>
		'use strict'
		$(document).on('click', '.deleteBtn', function () {
			var route = $(this).data('route');
            console.log(route)
			$('.deleteForm').attr('action', route);
		})

		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
		});

        new Sortable(document.getElementById('sortable-table'), {
            animation: 150,
            onEnd(evt) {
                let methods = [];
                $('.js-sortable tr').each(function (key, val) {
                    let methodID = $(val).data('id');
                    methods.push(methodID);
                });
                $.ajax({
                    url: "{{ route('user.payment.gateway.sort') }}",
                    method: "POST",
                    data: {
                        sort: methods,
                        _token: "{{ csrf_token() }}"
                    },
                });
            }
        });
	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
