@extends(template().'layouts.user')
@section('page_title',__('Add ons'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Add ons')</h2>
                    <div>
                        <a href="{{route('user.store.menu.optional.create')}}" class="btn-custom customButton"><i class="fal fa-plus"></i>@lang('Create')</a>
                        <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
                    </div>
				</div>
				<div class="table-responsive">
					<table
						class="table table-striped table-hover align-items-center table-flush"
						id="data-table">
						<thead class="thead-light">
						<tr>
							<th>@lang('SL.')</th>
							<th>@lang('Menu')</th>
							<th>@lang('Status')</th>
							<th>@lang('Created_at')</th>
							<th>@lang('Action')</th>
						</tr>
						</thead>
						<tbody>
						@forelse($optionalProducts as $key => $item)
							<tr>
								<td data-label="@lang('SL.')">{{++$key}}</td>
								<td data-label="Menu">
									<a href="javascript:void(0)"
									   class="text-decoration-none">
										<div class="d-lg-flex align-items-center text-end text-md-start">
                                            <img src="{{getFile($item->driver,$item->image)}}"
                                                alt="user" class="rounded-circle"
                                                width="40" data-toggle="tooltip"
                                                title=""
                                                data-original-title="{{$item->name}}">

											<div class=" ms-2">
												<p class="text-dark mb-0 font-16 font-weight-medium">
													{{$item->name}}</p>
												<span class="text-muted font-14 ms-1">{{ currencyPosition(getAmount($item->price)) }}</span>
											</div>
										</div>
									</a>
								</td>
								<td data-label="@lang('Status')">
									@if($item->status == 1)
										<span
											class="badge bg-success">@lang('Active')</span>
									@else
										<span
											class="badge bg-danger">@lang('Inactive')</span>
									@endif
								</td>
                                <td data-label="@lang('Created_at')">{{dateTime($item->created_at)}}</td>
								<td data-label="Action">
									<div class="sidebar-dropdown-items">
										<button
											type="button"
											class="dropdown-toggle customButton"
											data-bs-toggle="dropdown"
											aria-expanded="false">
											<i class="fal fa-cog"></i>
										</button>
										<ul class="dropdown-menu dropdown-menu-end">
											<li>
												<a href="{{route('user.store.menu.optional.edit',$item->id)}}" class="dropdown-item"> <i
														class="fal fa-edit"></i> @lang('Edit') </a>
											</li>
											<li>
												<button class="dropdown-item deleteAttr" type="button"
														data-bs-target="#attrDelete"
														data-bs-toggle="modal"
														data-route="{{route('user.store.menu.optional.delete',$item->id)}}">
													<i class="fal fa-trash text-danger"></i> @lang('Delete')
												</button>
											</li>
										</ul>
									</div>
								</td>
							</tr>
						@empty
                            <tr class="text-center">
                                <th class="text-center" colspan="100%">
                                    <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                    <p class="mt-3">@lang('No data available')</p>
                                </th>
                            </tr>
						@endforelse
						</tbody>
					</table>
				</div>
				<nav aria-label="Page navigation example">
					<ul class="pagination justify-content-center">
						{{ $optionalProducts->appends($_GET)->links(template().'partials.pagination') }}
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="modal fade" id="attrDelete" tabindex="-1" aria-labelledby="attrDelete" aria-hidden="true">
		<div class="modal-dialog modal-dialog-top modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="attrDelete">@lang('Delete Confirmation')</h5>
					<button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
						<i class="fal fa-times"></i>
					</button>
				</div>
				<div class="modal-body">
					<div class="row g-4">
						<p>@lang('Are you want to delete this Add ons?')</p>
					</div>
				</div>
				<div class="modal-footer">
					<form action="" method="post" class="deleteAttrForm">
						@csrf
						@method('delete')
						<button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
						<button type="submit" class="btn-custom">@lang('Yes')</button>
					</form>
				</div>
			</div>
		</div>
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Menu Name')" name="name" value="{{ @request()->name }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Min Price')" name="min_price" value="{{ @request()->min_price }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Max Price')" name="max_price" value="{{ @request()->max_price }}" type="text"
                                   class="form-control form-control-sm">
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group">
                                <select name="status" class="form-select" aria-label="Default select example">
                                    <option value="">@lang('All Status')</option>
                                    <option
                                        value="active" {{ @request()->status == 'active' ? 'selected' : '' }}>@lang('Active')</option>
                                    <option
                                        value="inactive" {{ @request()->status == 'inactive' ? 'selected' : '' }}>@lang('Inactive')</option>
                                </select>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <input placeholder="@lang('Date')" name="created_at" id="created_at"
                                   value="{{ request()->created_at ?? '' }}" type="date" class="form-control form-control-sm"
                                   autocomplete="off">
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
	<script>
		'use strict'
		$(document).on('click', '.deleteAttr', function () {
			var route = $(this).data('route');
			$('.deleteAttrForm').attr('action', route);
		})

	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
