@extends(template().'layouts.user')
@section('page_title',__('Set Telegram Bot'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-md-8">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Set Telegram Bot')</h2>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.telegram.set',$store->id) }}" method="post"
							  enctype="multipart/form-data">
							@csrf
							<div class="row">
								<div class="col-md-12">
									<div class="input-box form-group">
										<label for="Token">@lang('Token')</label>
										<input type="text"
											   name="telegram_token"
											   value="{{ old('telegram_token')??$store->telegram_token }}"
											   class="form-control"
											   placeholder="@lang('123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11')"
											   autocomplete="off">
										<div class="text-danger">
											@error('telegram_token') @lang($message) @enderror
										</div>
									</div>
								</div>
							</div>
							<div class="row mt-3">
								<div class="col-lg-4 input-box">
									<label>@lang('Initiate Image')</label>
									<div class="form-group position-relative">
										<div class="image-input z0">
											<label for="image-upload" id="image-label"><i
													class="fas fa-upload"></i></label>
											<input type="file" id="image" name="telegram_bot_image"
												   placeholder="@lang('Choose image')" class="image-preview">
											<img id="image_preview_container" class="preview-image"
												 src="{{ getFile($store->telegram_bot_image_driver,$store->telegram_bot_image) }}"
												 alt="@lang('preview image')">
										</div>
									</div>
									<div class="text-danger">
										@error('telegram_bot_image') @lang($message) @enderror
									</div>
									@if(config("filelocation.telegramBot"))
										<span class="text-warning">{{trans('Image size should be')}} {{config("filelocation.telegramBot.size")}} {{trans('px')}}</span>
									@endif
								</div>

                                <div class="col-lg-8">
                                    <div class="input-box form-group">
                                        <label
                                            for="Initiate Message">@lang('Initiate Message')</label>
                                        <textarea name="telegram_initiate_message" rows="13"
                                                  placeholder="@lang('Welcome please open menu and order food.')"
                                                  class="h-100 form-control form-control-sm">{{old('telegram_initiate_message')??$store->telegram_initiate_message}}</textarea>
                                        <div class="text-danger">
                                            @error('telegram_initiate_message') @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>
							</div>

							<button type="submit" class="btn-custom mt-3">@lang('Create Bot')</button>
						</form>
					</div>
				</section>
			</div>
			<div class="col-md-4 mt-5">
				<section class="profile-setting">
					<div class="sidebar-wrapper">
							<div class="row">
								<div class="col-md-12">
									<div class="d-flex justify-content-between">
										<h5>@lang('Instructions')</h5>
										<a href="{{route('user.store.telegram.docs')}}" target="_blank" class="btn-modify">@lang('How to set up')</a>
									</div>
								</div>
								<p class="mt-4">
									@lang('Curious to learn how to set up our bot quickly and effortlessly? Click the "How to Set Up" button below to access our comprehensive guide. Inside,')
									@lang("you'll find step-by-step instructions, screenshots, and tips to guide you through the setup process. Don't miss out on this valuable resource – get started now and unleash the full potential of our bot in no time!")
								</p>
							</div>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection

@push('script')
	<script>
		'use strict';
		$(document).on('change', '.image-preview', function () {
			let reader = new FileReader();
			reader.onload = (e) => {
				$('#image_preview_container').attr('src', e.target.result);
			}
			reader.readAsDataURL(this.files[0]);
		});
	</script>
@endpush

