@extends(template().'layouts.user')
@section('page_title',__('Edit Command Template'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<div class="d-flex justify-content-start">
						<h2 class="mb-0 text">@lang('Edit /')</h2>
						<h2 class="text-lowercase">{{$key}}</h2>
					</div>
				</div>
				<section class="profile-setting">
					<div class="sidebar-wrapper">
						<form action="{{ route('user.store.command.edit',[$store->id,$key]) }}" method="post">
							@csrf
							<div class="row">
                                <div class="col-12">
                                    <div class="input-box form-group">
                                        <label for="SHORTCODE">@lang('SHORTCODE')</label>
                                        <input type="text"
                                               name="name"
                                               value="{{optional($store->bot_command->$key)->key}}"
                                               class="form-control"
                                               autocomplete="off">
                                        <div class="text-danger">
                                            @error('name') @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="input-box form-group">
                                        <label for="Shot Message">@lang('Shot Message')</label>
                                        <input type="text"
                                               name="description"
                                               value="{{optional($store->bot_command->$key)->description}}"
                                               class="form-control"
                                               autocomplete="off" required>
                                        <div class="text-danger">
                                            @error('description') @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="input-box form-group">
                                        <label
                                            for="Command Message">@lang('Command Message')</label>
                                        <textarea name="command_text" rows="5"
                                                  class="form-control form-control-sm"
                                                  required>{{optional($store->bot_command->$key)->text}}</textarea>
                                        <div class="text-danger">
                                            @error('command_text') @lang($message) @enderror
                                        </div>
                                    </div>
                                </div>
							</div>
							<button type="submit" class="btn-custom mt-3">@lang('Save Changes')</button>
						</form>
					</div>
				</section>
			</div>
		</div>
	</div>
@endsection



