@extends(template().'layouts.store')
@section('page_title',__('Shipping Details'))

@section('content')
	<section class="checkout-section">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="heading d-flex justify-content-between">
						<div class="d-flex align-items-center">
							<a href="{{route('public.view',[$senderId,$link])}}" class="back-btn">
								<i class="fa-light fa-chevron-left"></i>
							</a>
							<h4>@lang('Shipping Details')</h4>
						</div>
						@include(template().'partials.user.cart-box')
					</div>
				</div>
				<div class="row">
					<div class="col-12">
						<form action="{{route('public.shipping',[$senderId,$link])}}" method="post">
							<div class="row g-3">
								<div class="input-box col-md-12">
									<input class="form-control" name="name" type="text" value="{{old('name')}}"
										   placeholder="@lang('Full Name')" required/>
									@error('name')
									<span class="text-danger">{{$message}}</span>
									@enderror
								</div>
								<div class="input-box col-md-6">
									<input class="form-control" name="email" type="text" value="{{old('email')}}"
										   placeholder="@lang('Email')" required/>
									@error('email')
									<span class="text-danger">{{$message}}</span>
									@enderror
								</div>
								<div class="input-box col-md-6">
									<input class="form-control" name="phone" type="text" value="{{old('phone')}}"
										   placeholder="@lang('Phone')" required/>
									@error('phone')
									<span class="text-danger">{{$message}}</span>
									@enderror
								</div>
								<div class="input-box col-md-12">
									<input class="form-control" name="address" value="{{old('address')}}" type="text"
										   placeholder="@lang('Detailed Address')" required/>
									@error('address')
									<span class="text-danger">{{$message}}</span>
									@enderror
								</div>
								<div class="input-box col-md-6">
									<select class="form-select" name="city" aria-label="Default select example" required>
										<option selected="" value="">@lang('Select City')</option>
										@if($shippingAddress)
											@foreach($shippingAddress as $address)
												<option
													value="{{$address->id}} {{old('city') == $address->id ? 'selected':''}}">{{$address->address}}</option>
											@endforeach
										@endif
									</select>
									@error('city')
									<span class="text-danger">{{$message}}</span>
									@enderror
								</div>
								<div class="input-box col-md-6">
									<input class="form-control" name="alt_phone" value="{{old('alt_phone')}}"
										   type="text"
										   placeholder="@lang('Alt. Phone (Optional)')"/>
								</div>
								@if($store->delivery_note == 'enable')
									<div class="input-box col-12">
                                       <textarea class="form-control" cols="30" rows="3" name="delivery_note"
												 placeholder="@lang('Note about your order, eg special notes for delivery.')">{{old('delivery_note')}}</textarea>
									</div>
								@endif
								<div class="input-box col-12">
									<button type="submit" class="btn-custom w-100">@lang('pay now')</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</section>
@endsection
@push('scripts')
	<script>
		'use strict'
		var link = "{{$link}}"
		let obj = JSON.parse(sessionStorage.getItem(link));
		if (obj == null || obj.length < 1) {
			$('.btn-custom').attr('disabled', true);
		}
		if (obj) {
			var countLength = Object.keys(obj).length;
			$("#showCart").text(countLength);
		} else {
			$("#showCart").text(0);
		}
	</script>
@endpush
