@extends(template().'layouts.store')
@section('page_title',__('My Cart'))

@section('content')
	<section class="cart-items">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="heading d-flex justify-content-between">
						<div class="d-flex align-items-center">
							<a href="{{route('public.view',[$senderId,$link])}}" class="back-btn">
								<i class="fa-light fa-chevron-left"></i>
							</a>
							<h4>@lang('My Cart')</h4>
						</div>
						@include(template().'partials.user.cart-box')
					</div>
				</div>
				<div class="row g-3" id="showHtml">

				</div>
				<div class="row">
					<div class="col">
						<div class="estimation-area mt-4">
							<p>@lang('Subtotal') <span class="subtotal">{{basicControl()->currency_symbol}}0.00</span>
							</p>
							<p class="total">@lang('Total') <span class="totalAmount">{{basicControl()->currency_symbol}}0.00</span>
							</p>
							<a href="{{route('public.shipping',[$senderId,$link])}}"
							   class="btn-custom w-100 checkoutBtn">@lang('Checkout')</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
@endsection
@push('scripts')
	<script>
		'use strict'
		var baseCurrency = "{{basicControl()->currency_symbol}}"
		var link = "{{$link}}"
		var cart = JSON.parse(sessionStorage.getItem(link));

		if (cart == null || cart.length < 1) {
			$('.checkoutBtn').addClass('d-none');
		}
		showCartItem(cart);


		$(document).on("click", ".removeBtn", function () {
			var id = $(this).data('id');
			removeCart(id);
		});

		$(document).on("click", ".increment", function () {
			let value = $(this).siblings("input").val();
			let id = $(this).siblings("input").data('id');
			updateCart(id);
		});

		$(document).on("click", ".decrement", function () {
			let value = $(this).siblings("input").val();
			let id = $(this).siblings("input").data('id');
			if (parseInt(value) > 1) {
				updateCart(id, 'decrement');
			}
		});

		function showCartItem(item = null) {
			$('#showHtml').html(``);
			var html = [];
			var subtotal = 0.00;
			var arrayCount = 0;
			Object.keys(item).forEach(function (key, value) {
				subtotal = parseFloat(subtotal) + parseFloat(item[key].totalPrice);
				arrayCount = value + 1;
				html += `<div class="col-lg-4 col-md-6 col-12">
							<div class="cart-menu-box">
								<div class="img-box">
									<img class="img-fluid" src="${item[key].image}"
										 alt="${item[key].productName}"/>
								</div>
								<div class="text-box">
									<a href="${item[key].url}" class="custom-a"><p>${item[key].productName}</p></a>
									<h5 class="price">${baseCurrency}${item[key].totalPrice}</h5>
									<div class="quantity">
										<button class="btn-inc-dec decrement">-</button>
										<input type="text" class="form-control counter" data-id="${key}" value="${item[key].quantity}"/>
										<button class="btn-inc-dec increment">+</button>
									</div>
									<button class="remove-btn removeBtn" data-id="${key}">
										<i class="fa-light fa-trash"></i>
									</button>
								</div>
							</div>
						</div>`
			});
			$('#showHtml').append(html);
			let sub = parseFloat(subtotal).toFixed(2)
			$('.subtotal').text(`${baseCurrency}${sub}`)
			$('.totalAmount').text(`${baseCurrency}${sub}`)
			$('.count').text(arrayCount)
		}

		function removeCart(id) {
			$.ajax({
				url: "{{ route('public.remove.cart') }}",
				method: "post",
				data: {
					id: id,
					items: JSON.parse(sessionStorage.getItem(link)),
				},
				success: function (res) {
					if (res.status == 'success') {
						sessionStorage.clear()
						sessionStorage.setItem(link, JSON.stringify(res.item));
						showCartItem(res.item)
					} else {
						Notiflix.Notify.failure("@lang('Something Went Wrong Please Try Again')");
					}
				}
			});
		}

		function updateCart(id, type = 'increment') {
			$.ajax({
				url: "{{ route('public.update.cart') }}",
				method: "post",
				data: {
					id: id,
					items: JSON.parse(sessionStorage.getItem(link)),
					type: type,
				},
				success: function (res) {
					if (res.status == 'success') {
						sessionStorage.clear()
						sessionStorage.setItem(link, JSON.stringify(res.item));
						showCartItem(res.item)
					} else {
						Notiflix.Notify.failure("@lang('Something Went Wrong Please Try Again')");
					}
				}
			});
		}
	</script>
@endpush
