@extends(template().'layouts.store')
@section('page_title',__('Checkout'))

@section('content')
	<section class="checkout-section cart-items">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="heading d-flex justify-content-between">
						<div class="d-flex align-items-center">
							<a href="{{route('public.view',[$order->sender_id,$link])}}" class="back-btn">
								<i class="fa-light fa-chevron-left"></i>
							</a>
							<h4>@lang('Checkout')</h4>
						</div>
						@include(template().'partials.user.cart-box')
					</div>
				</div>
				<div class="row">
					<div class="col-12">
						<h5>@lang('Order summary')</h5>
						<div class="order-summary">
							<div id="showHtml">

							</div>
							<div class="input-group promo-code">
								<input type="text" class="form-control promo_code" value=""
									   placeholder="@lang('Promo code')"/>
								<button id="promoApply">@lang('Apply')</button>
							</div>
							<div class="estimation-area mt-4">
								<p>@lang('Subtotal') <span
										class="subtotal">{{ basicControl()->currency_symbol }}0.00</span></p>
								<p>@lang('Delivery Charge') <span
										class="delivery_charge">{{ basicControl()->currency_symbol }}0.00</span></p>
								<p>@lang('Discount') <span
										class="discount">{{ basicControl()->currency_symbol }}0.00</span></p>
								<p class="total">@lang('Total') <span
										class="totalAmount">{{ basicControl()->currency_symbol }}0.00</span></p>
							</div>
						</div>
						<form>
							<div class="row g-3">
								<div class="input-box col-md-12">
									<div class="payment-box">
										<div class="payment-options">
                                            @if($gateways)
                                                @foreach($gateways as $key => $gateway)
                                                    <div class="payment-option">
                                                        <input
                                                            type="radio"
                                                            class="btn-check selectPayment"
                                                            name="gateway"
                                                            value="{{$gateway->id}}"
                                                            id="pay_opt_{{$key}}"
                                                            autocomplete="off"/>
                                                        <label class="btn btn-primary" for="pay_opt_{{$key}}">
                                                            <img class="img-fluid"
                                                                 src="{{getFile($gateway->driver,$gateway->image)}}"
                                                                 alt="..."/>
                                                            <img src="{{asset($themeTrue.'images/check.png')}}"
                                                                 alt="..." class="check"
                                                            /></label>
                                                    </div>
                                                @endforeach
                                            @endif
										</div>

                                        <input type="hidden" name="cvt_amount" value="" id="cvtAmount">
                                        <input type="hidden" class="form-control" name="amount" id="total_amount" value=""/>
                                        <div class="col-md-12 input-box mt-3 selectCurrencyInput selectItemInput d-none">
                                            <label for="">@lang('Select Currency')</label>
                                            <select class="js-example-basic-single form-control"
                                                    name="supported_currency"
                                                    id="supported_currency">
                                            </select>
                                        </div>
                                        <span class="invalid-feedback"></span>
                                        <div class="col-md-12 input-box mt-3 add-select-field selectCurrencyInput selectItemInput">

                                        </div>

                                        <div class="showCharge cart-total mt-3">

                                        </div>
										@if(optional($order->store)->cash_on_delivery == 1)
											<div class="row g-2 mt-2">
                                                @if(!empty($gateways) && count($gateways) > 0)
                                                    <div class="col-12">
                                                        <h5 class="mb-0">@lang('or')</h5>
                                                    </div>
                                                @endif
												<div class="col-3 col-md-2 col-lg-1">
													<input
														type="radio"
														class="btn-check codPayment"
														name="gateway"
														value="0"
														id="pay_opt_500"
														autocomplete="off"
													/>
													<label class="btn btn-primary" for="pay_opt_500">
														<img class="img-fluid"
															 src="{{asset($themeTrue.'images/cod-pay.png')}}"
															 alt="..."/>
														<img src="{{asset($themeTrue.'images/check.png')}}" alt="..."
															 class="check"
														/></label>
												</div>
											</div>
										@endif

                                        <div class="col-lg-12 input-box mt-3 add-select-field selectCurrencyInput">

                                        </div>
									</div>
								</div>
								@if(optional($order->store)->delivery_note == 'enable')
									<div class="input-box col-12">
                                       <textarea class="form-control order_note" cols="30" rows="3" name="order_note"
												 placeholder="@lang('Note about your order, eg special notes for order.')">{{old('order_note')}}</textarea>
									</div>
								@endif
								<div class="input-box col-12">
									<button type="button" class="btn-custom w-100 orderPlace">@lang('place order')</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</section>
@endsection
@push('scripts')
	<script>
		'use strict'
		var baseCurrency = "{{ basicControl()->currency_symbol }}"
		var link = "{{$link}}"
		var utr = "{{$utr}}"
		var cart = JSON.parse(sessionStorage.getItem(link));
		var orderUtr = "{{$utr}}";
		var shippingCharge = "{{$order->shipping_charge??0}}";
		showCartItem(cart);
		$(document).on("click", ".removeBtn", function () {
			var id = $(this).data('id');
			removeCart(id);
		});

		$(document).on("click", ".increment", function () {
			let value = $(this).siblings("input").val();
			let id = $(this).siblings("input").data('id');
			updateCart(id);
		});

		$(document).on("click", ".decrement", function () {
			let value = $(this).siblings("input").val();
			let id = $(this).siblings("input").data('id');
			if (parseInt(value) > 1) {
				updateCart(id, 'decrement');
			}
		});

		$(document).on("click", "#promoApply", function () {
			let promoCode = $('.promo_code').val();
			promoApply(link, orderUtr, promoCode)
		});

		$(document).on("click", ".orderPlace", function () {
			var gateway = $('input[name="gateway"]:checked').val();
            var supported_currency = $('#supported_currency').val();
            var supported_crypto_currency = $('#supported_crypto_currency').val();
			var note = $('.order_note').val();
			var cvtAmount = $('#cvtAmount').val();
			var total_amount = $('#total_amount').val();
			if (gateway == 0) {
				placeOrder(gateway, note);
			} else if (gateway != 0){
                placeOrder(gateway, note, cvtAmount, total_amount, supported_currency, supported_crypto_currency);
			}else {
				Notiflix.Notify.failure("@lang('Please Select A Payment Process')");
			}
		});

        $(document).ready(function() {
            let amountField = $('#total_amount');
            let amountStatus = false;
            let selectedGateway = "";
            $(document).on('click', '.selectPayment', function () {
                $('.selectCurrencyInput').removeClass('d-none');
                $('.showCharge').removeClass('d-none');
                selectedGateway = $(this).val();
                supportCurrency(selectedGateway);
            });

            $(document).on('click', '.codPayment', function () {
                $('.selectCurrencyInput').addClass('d-none');
                $('.invalid-feedback').hide();
                $('.showCharge').addClass('d-none');

            });

            function supportCurrency(selectedGateway) {
                if (!selectedGateway) {
                    console.error('Selected Gateway is undefined or null.');
                    return;
                }
                $('#supported_currency').empty();
                $('#supported_crypto_currency').empty();
                $('.add-select-field').empty();
                $('.showCharge').empty();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "{{ route('order.supported.currency') }}",
                    data: {gateway: selectedGateway},
                    type: "GET",
                    success: function (response) {

                        if (response.data == "") {
                            let markup = ``;
                            $('#supported_currency').append(markup);
                        }

                        let markup = '<option value="">Selected Currency</option>';
                        $('#supported_currency').append(markup);


                        if (response.currencyType == 1) {
                            $(response.data).each(function (index, value) {
                                let markup = `<option value="${value}">${value}</option>`;
                                $('#supported_currency').append(markup);
                            });
                        } else {
                            let markup = `<option value="USD">USD</option>`;
                            $('#supported_currency').append(markup);
                        }

                        let markup2 = '<option value="">Selected Crypto Currency</option>';
                        $('#supported_crypto_currency').append(markup2);

                        if (response.currencyType == 0){
                            let markup2 = `<label for="" class="">Pay To Crypto Currency</label>
                                        <select class="js-example-basic-single form-control mb-3"
                                                name="supported_crypto_currency"
                                                id="supported_crypto_currency">
                                              <option value="">Selected Crypto Currency</option>
                                        </select>`;
                            $('.add-select-field').append(markup2);
                            $('#supported_crypto_currency').select2();

                            $(response.data).each(function (index, value) {
                                let markupOption = `<option value="${value}">${value}</option>`;
                                $('#supported_crypto_currency').append(markupOption);
                            });
                        }
                    },
                    error: function (error) {
                        console.error('AJAX Error:', error);
                    }
                });
            }

            $(document).on('change, input', "#supported_currency, .selectPayment, #supported_crypto_currency", function (e) {
                let amount = amountField.val();

                let selectedCurrency = $('#supported_currency').val();
                let selectedCryptoCurrency = $('#supported_crypto_currency').val();
                let currency_type = 1;

                if (!isNaN(amount) && amount > 0) {
                    let fraction = amount.split('.')[1];
                    let limit = currency_type == 0 ? 8 : 2;

                    if (fraction && fraction.length > limit) {
                        amount = (Math.floor(amount * Math.pow(10, limit)) / Math.pow(10, limit)).toFixed(limit);
                        amountField.val(amount);
                    }
                    checkAmount(amount, selectedCurrency, selectedGateway, selectedCryptoCurrency)
                    if (selectedCurrency != null) {

                    }
                } else {
                    clearMessage(amountField)
                    $('.showCharge').html('')
                }
            });


            function clearMessage(fieldId) {
                $(fieldId).removeClass('is-valid')
                $(fieldId).removeClass('is-invalid')
                $(fieldId).closest('div').find(".invalid-feedback").html('');
                $(fieldId).closest('div').find(".is-valid").html('');
            }

            function checkAmount(amount, selectedCurrency, selectGateway, selectedCryptoCurrency = null) {
                $.ajax({
                    method: "GET",
                    url: "{{ route('order.checkConvertAmount') }}",
                    dataType: "json",
                    data: {
                        'amount': amount,
                        'selected_currency': selectedCurrency,
                        'select_gateway': selectGateway,
                        'selectedCryptoCurrency': selectedCryptoCurrency,
                    }
                }).done(function (response) {
                    if(response.status == false){
                        $('.selectedCurrecyCvtAmountError').text(response.message);
                    }
                    $('#cvtAmount').val(response.amount);
                    let amountField = $('#total_amount');
                    if (response.status) {
                        $('.selectedCurrecyCvtAmountError').text('');
                        clearMessage(amountField);
                        $(amountField).addClass('is-valid');
                        $(amountField).closest('div').find(".valid-feedback").html(response.message);
                        amountStatus = true;
                        let base_currency = "{{basicControl()->base_currency}}"
                        showCharge(response, base_currency);
                    } else {
                        amountStatus = false;
                        $('.showCharge').html('');
                        clearMessage(amountField);
                        $(amountField).addClass('is-invalid');
                        $(amountField).closest('div').find(".invalid-feedback").html(response.message);
                    }
                });
            }

            function showCharge(response, currency) {
                let txnDetails = `<ul class="list-group">
                                        <li class="list-group-item d-flex justify-content-between">
                                            <span>{{ __('Amount In') }} ${response.currency}</span>
                                            <span class="text-dark"> ${response.amount} ${response.currency}</span>
                                        </li>

                                        <li class="list-group-item d-flex justify-content-between">
                                            <span>{{ __('Charge') }}</span>
                                            <span class="text-dark">  ${response.charge} ${response.currency}</span>
                                        </li>


                                        <li class="list-group-item d-flex justify-content-between">
                                            <span>{{ __('Payable Amount') }}</span>
                                            <span class="text-dark"> ${response.payable_amount} ${response.currency}</span>
                                        </li>

                                        <li class="list-group-item d-flex justify-content-between">
                                            <span>{{ __('Payable Amount') }} <sub>(In Base Currency)</sub></span>
                                            <span class="text-dark"> ${response.amount_in_base_currency} ${currency}</span>
                                        </li>
                                    </ul>`;
                $('.showCharge').html(txnDetails)
            }

        });

		function showCartItem(item = null, discount = 0) {
			$('#showHtml').html(``);
			var html = [];
			var subtotal = 0.00;
			var arrayCount = 0;
			Object.keys(item).forEach(function (key, value) {
				subtotal = (parseFloat(subtotal) + parseFloat(item[key].totalPrice)).toFixed(2);
				arrayCount = value + 1;
				html += `<div class="cart-menu-box">
								<div class="img-box">
									<img class="img-fluid" src="${item[key].image}" alt="${item[key].productName}"/>
								</div>
								<div class="text-box">
                                      <a href="${item[key].url}" class="custom-a"><p>${item[key].productName}</p></a>
									<h5 class="price">${baseCurrency}${item[key].totalPrice}</h5>
									<div class="quantity">
										<button class="btn-inc-dec decrement">-</button>
										<input type="text" class="form-control counter" data-id="${key}" value="${item[key].quantity}"/>
										<button class="btn-inc-dec increment">+</button>
									</div>
								</div>
								 <button class="remove-btn  removeBtn" data-id="${key}">
								   <i class="fa-light fa-trash"></i>
								</button>
							</div>`
			});

			$('#showHtml').append(html);
			let deliveryCharge = parseFloat(shippingCharge).toFixed(2);
			$('.subtotal').text(`${baseCurrency}${subtotal}`)
			let finalAmount = ((parseFloat(subtotal) + parseFloat(deliveryCharge)) - parseFloat(discount)).toFixed(2)
			$('.delivery_charge').text(`+ ${baseCurrency}${deliveryCharge}`)
			$('.discount').text(`- ${baseCurrency}${discount}`)
			$('.totalAmount').text(`${baseCurrency}${finalAmount}`)
			$('#total_amount').val(`${finalAmount}`)
			$('.count').text(arrayCount)
		}

		function removeCart(id) {
			$.ajax({
				url: "{{ route('public.remove.cart') }}",
				method: "post",
				data: {
					id: id,
					items: JSON.parse(sessionStorage.getItem(link)),
				},
				success: function (res) {
					if (res.status == 'success') {
						sessionStorage.clear()
						sessionStorage.setItem(link, JSON.stringify(res.item));
						showCartItem(res.item)
					} else {
						Notiflix.Notify.failure("@lang('Something Went Wrong Please Try Again')");
					}
				}
			});
		}

		function updateCart(id, type = 'increment') {
			$.ajax({
				url: "{{ route('public.update.cart') }}",
				method: "post",
				data: {
					id: id,
					items: JSON.parse(sessionStorage.getItem(link)),
					type: type,
				},
				success: function (res) {
					if (res.status == 'success') {
						sessionStorage.clear()
						sessionStorage.setItem(link, JSON.stringify(res.item));
						showCartItem(res.item)
					} else {
						Notiflix.Notify.failure("@lang('Something Went Wrong Please Try Again')");
					}
				}
			});
		}

		function placeOrder(gateway, note = null, cvtAmount = null, total_amount = null, supported_currency = null, supported_crypto_currency = null) {

			$.ajax({
				url: "{{ route('public.payment') }}",
				method: "post",
				data: {
					gateway: gateway,
					cvt_amount: cvtAmount,
					total_amount: total_amount,
                    supported_currency: supported_currency,
                    supported_crypto_currency: supported_crypto_currency,
					note: note,
					link: link,
					utr: utr,
					items: JSON.parse(sessionStorage.getItem(link)),
				},
				success: function (res) {
					if (res.status == 'success') {
						if (res.msg == null) {
							window.location.href = res.url;
						} else {
							sessionStorage.clear();
							window.location.href = res.url;
						}
					} else {
						Notiflix.Notify.failure("@lang('The store is currently unreachable')");
					}
				}
			});
		}

		function promoApply(link, orderUtr, promoCode) {
			$.ajax({
				url: "{{ route('public.promo.apply') }}",
				method: "post",
				data: {
					items: JSON.parse(sessionStorage.getItem(link)),
					link: link,
					orderUtr: orderUtr,
					code: promoCode,
				},
				success: function (res) {
					if (res.status == 'success') {
						showCartItem(res.item, res.discount);
                        Notiflix.Notify.success(res.message);
					}
					else if (res.status == 'error') {
                        Notiflix.Notify.failure(res.message);
					} else {
						Notiflix.Notify.failure("@lang('Invalid promocode')");
					}
				}
			});
		}

	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{ trans($error) }}");
			@endforeach
		</script>
	@endif
@endpush
