@extends(template().'layouts.user')
@section('page_title',__('Purchase Plan List'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Purchase Plan List')</h2>
                    <button type="button" class="btn-custom customButton" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
				</div>
				<div class="table-responsive">
					<table
						class="table table-striped table-hover align-items-center table-borderless">
						<thead class="thead-light">
						<tr>
							<th>@lang('SL')</th>
							<th>@lang('Plan Name')</th>
							<th>@lang('Schedule')</th>
							<th>@lang('Price')</th>
							<th>@lang('Purchase Date')</th>
							<th>@lang('Expiry Date')</th>
							<th>@lang('Action')</th>
						</tr>
						</thead>
						<tbody>
						@forelse($purchasePlans as $key => $value)
							<tr>
								<td data-label="@lang('SL')">{{ 1 + $key++ }}</td>
								<td data-label="@lang('Plan Name')">
                                    <span class="{{ \Carbon\Carbon::parse($value->expiry_date) > \Carbon\carbon::now() ? 'badge bg-success' : '' }}">{{ $value->plan_name ?? __('N/A') }}</span>
								</td>
								<td data-label="@lang('Schedule')">{{ $value->schedule_name ?? __('N/A') }}</td>
								<td data-label="@lang('Price')">{{ currencyPosition(getAmount($value->price)) }}</td>
								<td data-label="@lang('Purchase Date')">
									{{ dateTime($value->purchase_date)}}
								</td>
								<td data-label="@lang('Expiry Date')">
									<span class="{{ \Carbon\Carbon::parse($value->expiry_date) < \Carbon\carbon::now() ? 'text-danger' : 'text-success' }}">{{ dateTime($value->expiry_date)}}</span>
								</td>
								<td data-label="Action">
									<div class="sidebar-dropdown-items">
										<button
											type="button"
											class="dropdown-toggle customButton"
											data-bs-toggle="dropdown"
											aria-expanded="false">
											<i class="fal fa-cog"></i>
										</button>
										<ul class="dropdown-menu dropdown-menu-end">
											<li>
												<a href="javascript:void(0)" class="dropdown-item detailsModal"
												   data-bs-toggle="modal"
												   data-bs-target="#detailsModal" data-resource="{{$value}}"
												   data-route="{{route('user.purchase.plan',[$value->schedule_id,'renew',$value->id])}}"> <i class="fal fa-eye"></i> @lang('Details') </a>
											</li>
										</ul>
									</div>
								</td>
							</tr>
						@empty
                            <tr class="text-center">
                                <th class="text-center" colspan="100%">
                                    <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                    <p class="mt-3">@lang('No data available')</p>
                                </th>
                            </tr>
						@endforelse
						</tbody>
					</table>
				</div>
				<nav aria-label="Page navigation example">
					<ul class="pagination justify-content-center">
                        {{ $purchasePlans->appends($_GET)->links(template().'partials.pagination') }}
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModal" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="detailsModal">@lang('Plan Details')</h5>
					<button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
						<i class="fal fa-times"></i>
					</button>
				</div>
				<form action="" method="GET" class="fromAction">
					<div class="modal-body">
						<div class="row g-4">
							<ul class="list-group">
								<li class="d-flex justify-content-between list-group-item">
									@lang('Plan Name')<span class="planName"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Purchase Date')<span class="purchaseDate"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item text-danger">
									@lang('Expiry Date')<span class="expiryDate"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Schedule')<span class="schedule"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Days')<span class="days"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Price')<span class="price"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Num of stores')<span class="num_stores"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Num of Menu')<span class="product_per_stores"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Num of Orders')<span class="orders_per_stores"></span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Telegram Bot')<span class="telegram_bot">@lang('No')</span>
								</li>
								<li class="d-flex justify-content-between list-group-item">
									@lang('Messenger Bot')<span class="messenger_bot">@lang('No')</span>
								</li>
							</ul>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
						<button type="submit" class="btn-custom d-none renew">@lang('Renew')</button>
					</div>
				</form>
			</div>
		</div>
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-lg-12">
                            <div class="form-group">
                                <input placeholder="@lang('Plan Name')" name="plan" value="{{ request()->plan ?? '' }}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group">
                                <input placeholder="@lang('Min Amount')" name="min" value="{{ request()->min ?? '' }}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group">
                                <input placeholder="@lang('Maximum Amount')" name="max" value="{{ request()->max ?? '' }}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <div class="form-group">
                                <input placeholder="@lang('Expiry Date')" name="expiry_date" id="created_at"
                                       value="{{ request()->expiry_date ?? '' }}" type="date" class="form-control form-control-sm"
                                       autocomplete="off">
                            </div>
                        </div>

                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('script')
	<script>
		'use strict'
		$(document).on("click", ".detailsModal", function () {
			$('.fromAction').attr('action', $(this).data('route'));
			let res = $(this).data('resource');

			let currency = "{{ basicControl()->base_currency }}"
			$('.planName').text(res.plan_name);
			$('.purchaseDate').text(new Date(res.created_at).toDateString());
			$('.expiryDate').text(new Date(res.expiry_date).toDateString());
			$('.schedule').text(res.schedule_name);
			$('.days').text(res.days);
			$('.price').text(`${res.price} ${currency}`);
			$('.num_stores').text(res.num_stores);
			$('.product_per_stores').text(res.product_qty);
			$('.orders_per_stores').text(res.order_num);
			if (res.telegram_bot == 1) {
				$('.telegram_bot').text(`Yes`);
			}
			if (res.messenger_bot == 1) {
				$('.messenger_bot').text(`Yes`);
			}

            var expiryDate = new Date(res.expiry_date);
            var now = new Date();
            if (expiryDate < now) {
                $('.renew').removeClass('d-none');
            }
		});
	</script>
@endpush
