@extends(template().'layouts.user')
@section('page_title',__('Order List'))

@section('content')
	<div class="container-fluid">
		<div class="main row">
			<div class="col-12">
				<div class="dashboard-heading">
					<h2 class="mb-0">@lang('Orders List')</h2>
				</div>
				<div class="dashboard-box-wrapper">
					<div class="row g-4 mb-4">
						<div class="col-xl-3 col-md-6 box">
							<div class="dashboard-box">
								<h5>@lang('New Arrivals')</h5>
								<h3>{{$orderRecords['newArrivals']}}</h3>
								<i class="fal fa-plus-circle"></i>
							</div>
						</div>
						<div class="col-xl-3 col-md-6 box">
							<div class="dashboard-box">
								<h5>@lang('Pending Orders')</h5>
								<h3>{{$orderRecords['pending']}}</h3>
								<i class="fal fa-spinner"></i>
							</div>
						</div>
						<div class="col-xl-3 col-md-6 box">
							<div class="dashboard-box">
								<h5>@lang('Delivered Orders')</h5>
								<h3>{{$orderRecords['delivered']}}</h3>
								<i class="fal fa-handshake-alt"></i>
							</div>
						</div>
						<div class="col-xl-3 col-md-6 box">
							<div class="dashboard-box">
								<h5>@lang('Remaining Orders')</h5>
								<h3>{{$remainingOrders}}</h3>
								<i class="fal fa-undo"></i>
							</div>
						</div>
					</div>
				</div>
				<div class="d-flex justify-content-end me-2 mb-2">
					<div class="sidebar-dropdown-items">
						<button
							type="button"
							class="dropdown-toggle customButton me-4"
							data-bs-toggle="dropdown"
							aria-expanded="false">
							<i class="fal fa-cog"></i>
                            @lang('Action')
						</button>
						<ul class="dropdown-menu dropdown-menu-end">
							<li>
								<a href="javascript:void(0)" class="dropdown-item changeClick"
								   data-bs-toggle="modal"
								   data-bs-target="#stageChange" data-stage="In Process"> <i
										class="fal fa-spinner"></i> @lang('In Process') </a>
							</li>
							<li>
								<a href="javascript:void(0)" class="dropdown-item changeClick"
								   data-bs-toggle="modal"
								   data-bs-target="#stageChange" data-stage="Out For Delivery">
									<i
										class="fal fa-hiking"></i> @lang('Out For Delivery')
								</a>
							</li>
							<li>
								<a href="javascript:void(0)"
								   class="dropdown-item changeClick" data-bs-toggle="modal"
								   data-bs-target="#stageChange" data-stage="Delivered"> <i
										class="fal fa-handshake-alt"></i> @lang('Delivered')
								</a>
							</li>
							<li>
								<a href="javascript:void(0)"
								   class="dropdown-item changeClick" data-bs-toggle="modal"
								   data-bs-target="#stageChange" data-stage="Cancel"> <i
										class="fal fa-times"></i> @lang('Cancel') </a>
							</li>
						</ul>
					</div>
                    <button type="button" class="btn-custom ms-2 dropdown-toggle customButton w-90" id="customOffcanvasBtn"><i class="fal fa-filter"></i>@lang('Filter')</button>
				</div>
				<div class="table-responsive">
					<table
						class="table table-striped table-hover align-items-center table-flush">
						<thead class="thead-light">
						<tr>
							<th scope="col" class="text-center">
								<input type="checkbox"
									   class="form-check-input check-all tic-check"
									   name="check-all"
									   id="check-all">
								<label for="check-all"></label>
							</th>
							<th>@lang('Order Number')</th>
                            <th>@lang('Store')</th>
                            <th>@lang('Email')</th>
                            <th>@lang('Payment Amount')</th>
                            <th>@lang('Payment By')</th>
                            <th>@lang('Stage')</th>
                            <th>@lang('Date Time')</th>
                            <th>@lang('Action')</th>
						</tr>
						</thead>
						<tbody>
						@forelse($orders as $key => $item)
							<tr>
								<td class="text-center">
									<input type="checkbox" id="chk-{{ $item->id }}"
										   class="form-check-input row-tic tic-check"
										   name="check" value="{{$item->id}}"
										   data-id="{{ $item->id }}">
									<label for="chk-{{ $item->id }}"></label>
								</td>

								<td data-label="@lang('Order Number')">
									{{$item->order_number}}</td>
								<td data-label="Store">
									@lang(optional($item->store)->name)
								</td>
								<td data-label="@lang('Email')">{{$item->email}}</td>
								<td data-label="@lang('Payment Amount')">
                                    <span class="text-dark font-weight-bold">{{ currencyPosition(getAmount($item->payment_amount)) }}</span>
								</td>
								<td data-label="@lang('Payment By')">
									@if($item->gateway_id == 0)
										@lang('Cash On Delivery')
									@else
										{{optional($item->gateway)->name}}
									@endif
								</td>
								<td data-label="@lang('Stage')">
									@if($item->stage == 0)
										<span class="badge bg-warning">@lang('New Arrive')</span>
									@elseif($item->stage == 1)
										<span class="badge bg-success">@lang('Delivered')</span>
									@elseif($item->stage == 2)
										<span class="badge bg-info">@lang('In Process')</span>
									@elseif($item->stage == 3)
										<span
											class="badge bg-primary">@lang('Out For Delivery')</span>
									@elseif($item->stage == 4)
										<span
											class="badge bg-danger">@lang('Cancel')</span>
									@endif
								</td>
                                <td data-label="@lang('Date Time')">
                                    {{dateTime($item->created_at,'d-M-Y H:i')}}</td>
								<td data-label="Action">
									<div class="sidebar-dropdown-items">
										<button
											type="button"
											class="dropdown-toggle customButton"
											data-bs-toggle="dropdown"
											aria-expanded="false">
											<i class="fal fa-cog"></i>
										</button>
										<ul class="dropdown-menu dropdown-menu-end">
											<li>
												<a href="{{route('user.order.details',$item->order_number)}}"
												   class="dropdown-item"> <i class="fal fa-eye"></i> @lang('View') </a>
											</li>
										</ul>
									</div>
								</td>
							</tr>
						@empty
                            <tr class="text-center">
                                <th class="text-center" colspan="100%">
                                    <img class="noDataImg" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="image">
                                    <p class="mt-3">@lang('No data available')</p>
                                </th>
                            </tr>
						@endforelse
						</tbody>
					</table>
				</div>
				<nav aria-label="Page navigation example">
					<ul class="pagination justify-content-center">
                        {{ $orders->appends($_GET)->links(template().'partials.pagination') }}
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="modal fade" id="stageChange" tabindex="-1" aria-labelledby="stageChange" aria-hidden="true">
		<div class="modal-dialog modal-dialog-top modal-md">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="stageChange">@lang('Stage Change Confirmation')</h5>
					<button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
						<i class="fal fa-times"></i>
					</button>
				</div>
				<div class="modal-body">
					<div class="row g-4">
						<p id="msgShow"></p>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn-custom btn2" data-bs-dismiss="modal">@lang('Close')</button>
					<button type="submit" class="btn-custom change-yes">@lang('Yes')</button>
				</div>
			</div>
		</div>
	</div>

    <div class="custom-offcanvas end ">
        <div class="custom-offcanvas-header">
            <h4 class="custom-offcanvas-title mb-0">@lang('Filter')</h4>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="custom-offcanvas-body">
            <div class="search-bar canvas_input_box">
                <form action="" method="get">
                    <div class="row g-3 align-items-end">
                        <div class="col-lg-12 input-box">
                            <div class="form-group">
                                <input placeholder="@lang('Store Name')" name="store_name" value="{{@request()->store_name}}"
                                       type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="col-lg-12 input-box">
                            <div class="form-group">
                                <input placeholder="@lang('Order Number')" name="orderNumber" value="{{@request()->orderNumber}}"
                                       type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="col-lg-12 input-box">
                            <div class="form-group">
                                <input placeholder="@lang('Email')" name="email" value="{{@request()->email}}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="col-lg-12 input-box">
                            <div class="form-group">
                                <input placeholder="@lang('Amount')" name="amount" value="{{@request()->amount}}" type="text"
                                       class="form-control form-control-sm">
                            </div>
                        </div>
                        <div class="col-lg-12 input-box">
                            <div class="form-group search-currency-dropdown">
                                <select name="stage" class="form-control form-control-sm">
                                    <option value="">@lang('All Status')</option>
                                    <option
                                        value="0" {{ @request()->stage == '0' ? 'selected' : '' }}>@lang('New Arrival')</option>
                                    <option
                                        value="2" {{ @request()->stage == '2' ? 'selected' : '' }}>@lang('In Process')</option>
                                    <option
                                        value="3" {{ @request()->stage == '3' ? 'selected' : '' }}>@lang('Out For Delivery')</option>
                                    <option
                                        value="1" {{ @request()->stage == '1' ? 'selected' : '' }}>@lang('Delivered')</option>
                                    <option
                                        value="4" {{ @request()->stage == '4' ? 'selected' : '' }}>@lang('Cancel')</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12 input-box">
                            <div class="input-box form-group">
                                <input type="date" class="form-control" name="datetrx" id="datepicker"/>
                            </div>
                        </div>
                        <div class="input-box col-lg-12">
                            <button type="submit" class="btn-custom w-100"><i class="fal fa-search"></i> @lang('Filter')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
	<script>
		'use strict'
		var stage = null;
		$(document).on('click', '.changeClick', function () {
			let showStage = $(this).data('stage');
			$('#msgShow').text(`Are You Sure To Change This Stage ${showStage}`)
			stage = showStage;
		});

		$(document).on('click', '#check-all', function () {
			$('input:checkbox').not(this).prop('checked', this.checked);
		});

		$(document).on('change', ".row-tic", function () {
			let length = $(".row-tic").length;
			let checkedLength = $(".row-tic:checked").length;
			if (length == checkedLength) {
				$('#check-all').prop('checked', true);
			} else {
				$('#check-all').prop('checked', false);
			}
		});

		$(document).on('click', '.change-yes', function (e) {
			e.preventDefault();
			var allVals = [];
			$(".row-tic:checked").each(function () {
				allVals.push($(this).attr('data-id'));
			});

			var strIds = allVals;

			$.ajax({
				headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
				url: "{{ route('user.order.multiple.stage.change') }}",
				data: {strIds: strIds, stage: stage},
				datatType: 'json',
				type: "post",
				success: function (data) {
					location.reload();
				},
			});
		});
	</script>
	@if ($errors->any())
		@php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		@endphp
		<script>
			"use strict";
			@foreach ($errors as $error)
			Notiflix.Notify.failure("{{trans($error)}}");
			@endforeach
		</script>
	@endif
@endpush
