
<section class="plan-section {{ getLastSegment() == 'Pricing' ? 'plan-page' : '' }}">
	<div class="container">
		@if(!empty($plan['single']) && getLastSegment() != 'Pricing')
			<div class="row">
				<div class="col-12">
					<div class="header-text text-center">
						<h5>@lang($plan['single']['heading'] ?? '')</h5>
						<h2>@lang($plan['single']['title'] ?? '')</h2>
						<p class="mx-auto">@lang($plan['single']['sub_title'] ?? '')</p>
					</div>
				</div>
			</div>
		@endif

		@if(!empty($plan['schedules']))
			<div class="text-center">
				<div class="nav nav-pills" id="pills-tab" role="tablist">
					@foreach($plan['schedules'] as $key => $schedule)
						<button
							class="btn-custom {{($key == 0)?'active':''}}"
							id="pills-{{$key}}-tab"
							data-bs-toggle="pill"
							data-bs-target="#pills-{{$key}}"
							type="button"
							role="tab"
							aria-controls="pills-{{$key}}"
							aria-selected="true">
							{{optional($schedule->details)->name}}
						</button>
					@endforeach
				</div>
			</div>

			<div class="tab-content" id="pills-tabContent">
				@foreach($plan['schedules'] as $key => $schedule)
					<div class="tab-pane fade {{($key == 0)?'show active':''}}"
						id="pills-{{$key}}"
						role="tabpanel"
						aria-labelledby="pills-{{$key}}-tab">
						<div class="row g-4 g-lg-5">
							@if($schedule->plans)
								@foreach($schedule->plans as $plan)
									@if(optional($plan->planDetail)->status == 0)
										@php
											continue;
										@endphp
									@endif
									<div class="col-lg-4 col-md-6">
										<div class="plan-box"
											data-aos="fade-up"
											data-aos-duration="1000"
											data-aos-anchor-placement="center-bottom">
											<div class="top-area">
												<h4>{{ optional(optional($plan->planDetail)->details)->plan_name }}</h4>
												<h1>{{ currencyPosition($plan->price) }}
													<span>/{{ucfirst(optional($schedule->details)->name)}}</span></h1>
												<p>{{ optional(optional($plan->planDetail)->details)->note }}</p>
											</div>
											<ul>
												<li>
													<i class="fal fa-check-circle fa-2x text-success"></i>{{ optional($plan->planDetail)->num_stores }} @lang('Number of stores')
												</li>
												<li>
													<i class="fal fa-check-circle fa-2x text-success"></i>{{ optional($plan->planDetail)->product_qty }} @lang('Menu Items Business')
												</li>
												<li>
													<i class="fal fa-check-circle fa-2x text-success"></i> {{ optional($plan->planDetail)->order_num }} @lang('Orders completed')
												</li>

												<li>
                                                    <i class="{{ optional($plan->planDetail)->telegram_bot == 1 ? 'fal fa-check-circle fa-2x text-success' : 'fal fa-times-circle fa-2x text-danger' }}"></i>
                                                    @lang('Telegram Bot')
												</li>

												<li>
                                                    <i class="{{ optional($plan->planDetail)->messenger_bot == 1 ? 'fal fa-check-circle fa-2x text-success' : 'fal fa-times-circle fa-2x text-danger' }}"></i>
													@lang('Messenger Bot')
												</li>

												<li>
                                                    <i class="{{ optional($plan->planDetail)->whatsapp_bot == 1 ? 'fal fa-check-circle fa-2x text-success' : 'fal fa-times-circle fa-2x text-danger' }}"></i>
													@lang('Whatsapp Bot')
												</li>
											</ul>
											<a href="{{ route('user.purchase.plan',$plan->id) }}"
											   class="btn-custom w-100">@lang('Get started')</a>
											<span class="feature">{{ ucfirst(optional(optional($plan->planDetail)->details)->plan_name) }}</span>
										</div>
									</div>
								@endforeach
							@endif
						</div>
					</div>
				@endforeach
			</div>
		@endif
	</div>
</section>
