<div class="contact-section">
    <div class="container">
        @if(!empty($contact))
            <div class="info-wrapper">
                <div class="row g-lg-5 g-4">
                    <div class="col-lg-4">
                        <div class="info-box">
                            <div class="icon"><img src="{{asset($themeTrue.'images/location.png')}}" alt="..."/>
                            </div>
                            <div class="text">
                                <h4>@lang('Location')</h4>
                                <p>@lang($contact['single']['location'] ?? '')</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="info-box">
                            <div class="icon"><img src="{{asset($themeTrue.'images/at.png')}}" alt=".."/></div>
                            <div class="text">
                                <h4>@lang('Email')</h4>
                                <p>@lang($contact['single']['email'] ?? '')</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="info-box">
                            <div class="icon"><img src="{{asset($themeTrue.'images/phone.png')}}" alt="..."/></div>
                            <div class="text">
                                <h4>@lang('Phone')</h4>
                                <p>@lang($contact['single']['phone'] ?? '')</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        <div class="row g-4 justify-content-center">
            <div class="col-lg-8 text-center">
                <div class="header-text">
                    <h5>@lang($contact['single']['title'] ?? '')</h5>
                    <h3>@lang($contact['single']['sub_title'] ?? '')</h3>
                </div>
                <form action="{{ route('contact.send') }}" method="post">
                    @csrf
                    <div class="row g-3">
                        <div class="input-box col-md-6">
                            <input class="form-control" type="text" name="name" value="{{old('name')}}"
                                   placeholder="@lang('Full name')"/>
                            @error('name')
                            <div class="text-start text-danger">
                                {{$message}}
                            </div>
                            @enderror
                        </div>
                        <div class="input-box col-md-6">
                            <input class="form-control" type="email" name="email" value="{{old('email')}}"
                                   placeholder="@lang('Email address')"/>
                            @error('email')
                            <div class="text-start text-danger">
                                {{$message}}
                            </div>
                            @enderror
                        </div>
                        <div class="input-box col-md-12">
                            <input class="form-control" type="text" name="subject"
                                   value="{{old('subject')}}" placeholder="@lang('Subject')"/>
                            @error('subject')
                            <div class="text-start text-danger">
                                {{$message}}
                            </div>
                            @enderror
                        </div>
                        <div class="input-box col-12">
                                    <textarea class="form-control" cols="30" rows="3" name="message"
                                              placeholder="@lang('Your message')">{{old('message')}}</textarea>
                            @error('message')
                            <div class="text-start text-danger">
                                {{$message}}
                            </div>
                            @enderror
                        </div>
                        <div class="input-box col-12">
                            <button class="btn-custom w-100" type="submit">@lang('submit')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
