@extends('admin.layouts.app')
@section('page_title','Store Details')
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Manage Module')</li>
                            <li class="breadcrumb-item" aria-current="page">@lang('Stores')</li>
                            <li class="breadcrumb-item active" aria-current="page">@lang('Details')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@lang('Store - '.$store->name)</h1>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang('Store Information')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-lg-4">
                                <div class="input-box form-group">
                                    <label class="form-label" for="Store Name">@lang('Store Name')</label>
                                    <input class="form-control text-secondary" value="@lang($store->name ?? 'N/A')" readonly>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label">@lang('Shipping Charge')</label>
                                <div class="list-group-item">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <div class="row align-items-center">
                                                <div class="col">
                                                <span class="d-block fs-6 text-body">
                                                    @lang('Shipping Charge is required if checked')
                                                </span>
                                                </div>
                                                <div class="col-auto">
                                                    <label class="row form-check form-switch mb-3" for="is_video">
                                                    <span class="col-4 col-sm-3 text-end">
                                                        <input type='hidden' value='0' name='status'>
                                                        <input class="form-check-input" type="checkbox" id="status" value="1" {{ $store->shipping_charge == 1 ? 'checked' : '' }}>
                                                    </span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label">@lang('Delivery Note')</label>
                                <div class="list-group-item">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <div class="row align-items-center">
                                                <div class="col">
                                                <span class="d-block fs-6 text-body">
                                                    @lang('Delivery Note is Enabled if checked')
                                                </span>
                                                </div>
                                                <div class="col-auto">
                                                    <label class="row form-check form-switch mb-3" for="is_video">
                                                    <span class="col-4 col-sm-3 text-end">
                                                        <input type='hidden' value='0'>
                                                        <input class="form-check-input" type="checkbox" id="status" value="1" {{ $store->delivery_note == 'Enable' ? 'checked' : '' }}>
                                                    </span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="input-box form-group">
                                    <label class="form-label" for="Store Name">@lang('Store Description (optional)')</label>
                                    <textarea class="form-control text-secondary bg-transparent" rows="3" disabled>@lang($store->short_description ?? 'N/A')</textarea>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label">@lang('Cash On Delivery')</label>
                                <div class="list-group-item">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <div class="row align-items-center">
                                                <div class="col">
                                                <span class="d-block fs-6 text-body">
                                                    @lang('Cash On Delivery is ON if checked')
                                                </span>
                                                </div>
                                                <div class="col-auto">
                                                    <label class="row form-check form-switch mb-3" for="is_video">
                                                    <span class="col-4 col-sm-3 text-end">
                                                        <input type='hidden' value='0'>
                                                        <input class="form-check-input" type="checkbox" id="status" value="1" {{ $store->cash_on_delivery == 1 ? 'checked' : '' }}>
                                                    </span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label">@lang('Status')</label>
                                <div class="list-group-item">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <div class="row align-items-center">
                                                <div class="col">
                                                <span class="d-block fs-6 text-body">
                                                    @lang('Status is ON if checked')
                                                </span>
                                                </div>
                                                <div class="col-auto">
                                                    <label class="row form-check form-switch mb-3" for="is_video">
                                                    <span class="col-4 col-sm-3 text-end">
                                                        <input type='hidden' value='0'>
                                                        <input class="form-check-input" type="checkbox" id="status" value="1" {{ $store->status == 1 ? 'checked' : '' }}>
                                                    </span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang('Whatsapp Bot')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('SID')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->whatsapp_sid}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Token')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->whatsapp_token}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Business Account')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->whatsapp_business_account}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Callback URL')</label>
                                    <input type="text" class="form-control text-secondary" value="{{route('whatsappWebhook',$store->link)}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Initiate Message')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->whatsapp_initiate_message}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <label class="form-label">@lang('Initiate Image')</label>
                                    <div>
                                        <img src="{{ getFile($store->whatsapp_bot_image_driver,$store->whatsapp_bot_image) }}" alt="image" width="200px" height="200px">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang('Messenger Bot')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Facebook Token')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->messenger_token}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Callback URL')</label>
                                    <input type="text" class="form-control text-secondary" value="{{route('messengerWebhook',$store->link)}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Verify Token')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->link}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Initiate Message')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->messenger_initiate_message}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <label class="form-label">@lang('Initiate Image')</label>
                                    <div>
                                        <img src="{{ getFile($store->messenger_bot_image_driver,$store->messenger_bot_image) }}" alt="image" width="200px" height="200px">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang('Telegram Bot')</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Token')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->telegram_token}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label" for="Store Name">@lang('Initiate Message')</label>
                                    <input type="text" class="form-control text-secondary" value="{{$store->telegram_initiate_message}}" readonly>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <label class="form-label">@lang('Initiate Image')</label>
                                    <div>
                                        <img src="{{ getFile($store->telegram_bot_image_driver,$store->telegram_bot_image) }}" alt="image" width="200px" height="200px">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header card-header-content-md-between">
                        <h4>@lang('Command List')</h4>
                    </div>
                    <div class="card-body">
                        <div class=" table-responsive datatable-custom  ">
                            <table class="table table-striped table-hover table-thead-bordered  table-align-middle card-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th>@lang('No')</th>
                                        <th>@lang('Command')</th>
                                        <th>@lang('Description')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($store->bot_command as $key => $item)
                                        <tr>
                                            <td data-label="Command">{{ $loop->iteration }}</td>
                                            <td data-label="Command">/@lang($key)</td>
                                            <td data-label="@lang('Description')">@lang($item->description)</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection





