<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->index();
            $table->foreignId('gateway_id')->nullable()->index();
            $table->foreignId('deposit_id')->nullable()->index();
            $table->string('trx_id')->nullable();
            $table->foreignId('plan_id')->nullable()->index();
            $table->foreignId('schedule_id')->nullable()->index();
            $table->string('plan_name')->nullable();
            $table->string('schedule_name')->nullable();
            $table->string('days')->nullable();
            $table->string('badge_name')->nullable();
            $table->integer('num_stores')->nullable();
            $table->integer('product_qty')->nullable();
            $table->integer('order_num')->nullable();
            $table->tinyInteger('telegram_bot')->nullable();
            $table->tinyInteger('messenger_bot')->nullable();
            $table->tinyInteger('whatsapp_bot')->nullable();
            $table->double('price')->nullable();
            $table->timestamp('purchase_date')->nullable();
            $table->string('type')->nullable();
            $table->timestamp('expiry_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_plans');
    }
};
