<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Store extends Model
{
    use HasFactory;

    protected $table = 'stores';
    protected $guarded =['id'];
    protected $casts = [
        'bot_command' => 'object'
    ];

    public function scopeOwn($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function productsMap()
    {
        return $this->hasMany(ProductStoreMap::class, 'store_id')->groupBy('product_id');
    }

    public function productsCount()
    {
        return ProductStoreMap::where('store_id', $this->id)->distinct('product_id')->count();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function orders()
    {
        return $this->hasMany(Order::class, 'store_id');
    }

    public static function boot(): void
    {
        parent::boot();
        static::saved(function () {
            Cache::forget('storeRecord');
        });
    }
}
