<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use PDF;

class SendOrderMail extends Mailable
{
	use Queueable, SerializesModels;

	/**
	 * Create a new message instance.
	 *
	 * @return void
	 */
	public $order;
	public $theme;

	public function __construct($order)
	{
		$this->theme = template();
		$this->order = $order;
	}

	/**
	 * Build the message.
	 *
	 * @return $this
	 */
	public function build()
	{
        $basic = basicControl();
		$mailMessage = $this->subject("Order Receipt")
			->from($basic->sender_email, $basic->sender_email_name)
			->attachData($this->pdf(), $this->order->order_number . '_Order.pdf', [
				'mime' => 'application/pdf',
			]);

		$mailMessage->view($this->theme . 'mail.order', [
			'storeName' => optional($this->order->store)->name ?? 'unknown',
			'orderNumber' => $this->order->order_number,
			'paidType' => ($this->order->gateway_id == 0 ? 'Offline' : 'Online'),
			'gateway' => ($this->order->gateway_id == 0 ? 'Cash On Delivery' : $this->order->gateway->name),
			'orderDate' => dateTime($this->order->created_at, 'd/M/Y H:i'),
			'deliveryAddress' => optional($this->order->shipping)->address ?? 'unknown',
			'detailsAddress' => $this->order->detailed_address ?? 'unknown',
			'deliveryNote' => $this->order->delivery_note ?? '',
			'orderNote' => $this->order->order_note ?? '',
			'fullName' => $this->order->full_name ?? 'unknown',
			'email' => $this->order->email ?? 'unknown',
			'phone' => $this->order->phone ?? 'unknown',
			'items' => $this->order->details,
			'deliveryFee' => getAmount($this->order->shipping_charge, 2) ?? 0,
			'discount' => getAmount($this->order->discount_amount, 2) ?? 0,
			'subtotal' => getAmount($this->order->total_amount, 2) ?? 0,
			'paymentAmount' => getAmount($this->order->payment_amount, 2) ?? 0,
			'currencySymbol' => $basic->currency_symbol,
		]);
	}

	private function pdf()
	{

		$pdf = PDF::loadView($this->theme . 'pdf.order', [
			'storeName' => optional($this->order->store)->name ?? 'unknown',
			'orderNumber' => $this->order->order_number,
			'paidType' => ($this->order->gateway_id == 0 ? 'Offline' : 'Online'),
			'gateway' => ($this->order->gateway_id == 0 ? 'Cash On Delivery' : $this->order->gateway->name),
			'orderDate' => dateTime($this->order->created_at, 'd/M/Y H:i'),
			'deliveryAddress' => optional($this->order->shipping)->address ?? 'unknown',
			'detailsAddress' => $this->order->detailed_address ?? 'unknown',
			'deliveryNote' => $this->order->delivery_note ?? '',
			'orderNote' => $this->order->order_note ?? '',
			'fullName' => $this->order->full_name ?? 'unknown',
			'email' => $this->order->email ?? 'unknown',
			'phone' => $this->order->phone ?? 'unknown',
			'items' => $this->order->details,
			'deliveryFee' => getAmount($this->order->shipping_charge, 2) ?? 0,
			'discount' => getAmount($this->order->discount_amount, 2) ?? 0,
			'subtotal' => getAmount($this->order->total_amount, 2) ?? 0,
			'paymentAmount' => getAmount($this->order->payment_amount, 2) ?? 0,
			'currencySymbol' => basicControl()->currency_symbol,
		]);
		return $pdf->stream();
	}
}
