<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Gateway;
use App\Models\Page;
use App\Models\Plan;
use App\Models\PlanSchedule;
use App\Models\PurchasePlan;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PurchasePlanController extends Controller
{
    public function purchasePlan($plan_schedule_id, $type = null, $purchase_id = null)
    {
        $pageSeo = Page::where('template_name', getTheme())->where('slug', 'purchase-plan')->first();
        $pageSeo['breadcrumb_image'] = $pageSeo?->breadcrumb_status == 1 ? getFile($pageSeo->breadcrumb_image_driver, $pageSeo->breadcrumb_image) : null;

        $data['planSchedule'] = PlanSchedule::with(['planDetail'])->whereHas('planDetail', function ($query){
            $query->where('status',1);
        })->findOrFail($plan_schedule_id);

        $data['pageSeo'] = $pageSeo;
        $data['purchase_id'] = $purchase_id;
        $data['gateways'] = Gateway::where('status', 1)->select('id','code','name','image','driver','status','description')->toBase()->get();

        if ($type == 'renew') {
            $existingPurchasePlan = PurchasePlan::where('user_id', auth()->id())->where('plan_id', $data['planSchedule']->plan_id)->first();
            if (!$existingPurchasePlan) {
                return back()->with('error', 'No previous purchase found for this package.');
            }
            return $this->showPaymentPage($data, 'renew');
        }
        return $this->showPaymentPage($data);
    }

    protected function showPaymentPage($data, $type = null)
    {
        $data['type'] = $type;
        $data['user'] = Auth::user();
        return view(template().'pricing_payment_page', $data);
    }

    public function purchasePlanList(Request $request)
    {
        $search = $request->all();
        $dateSearch = Carbon::parse($request->created_at);
        $userId = auth()->id();
        $purchasePlans = PurchasePlan::own($userId)
            ->when(isset($search['plan']), function ($query) use ($search) {
                $query->where('plan_name', 'LIKE', '%' . $search['plan'] . '%');
            })
            ->when(isset($search['min']), function ($query) use ($search) {
                return $query->where('price', '>=', $search['min']);
            })
            ->when(isset($search['max']), function ($query) use ($search) {
                return $query->where('price', '<=', $search['max']);
            })
            ->when(isset($search['expiry_date']), function ($query) use ($search) {
                return $query->whereDate("created_at", $search['expiry_date']);
            })
            ->latest()->paginate(basicControl()->paginate);
        return view(template(). 'user.purchase_plan.index', compact('purchasePlans'));
    }

}
